package io.fogcloud.sdk.mdns.api;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

import io.fogcloud.sdk.mdns.helper.CommonFunc;
import io.fogcloud.sdk.mdns.helper.MDNSErrCode;
import io.fogcloud.sdk.mdns.helper.SearchDeviceCallBack;

public class MDNS {

    private CommonFunc comfunc = new CommonFunc();
    private boolean isWorking = false;
    private WifiManager wifiManager = null;
    private Map<String, JSONObject> jsonmap = null;
    // message.what
    private final int _ADDDEVICE = 1002;
    private final int _REMOVEDEVICE = 1003;

    private Context mContext;
    private SearchDeviceCallBack msearchdevcb;

    /**
     * callback
     */
    private JSONArray array;// callback array


    private String mserviceName;
    private JmDNS jmdns;
    private SampleListener slistener;


    public MDNS(Context context) {
        this.mContext = context;
    }

    /**
     * Start mDNS to search my devices.
     *
     * @param serviceName serviceName
     * @param searchdevcb searchdevcb
     */
    public void startSearchDevices(String serviceName,
                                   SearchDeviceCallBack searchdevcb) {
        if (comfunc.checkPara(serviceName)) {
            if (null != mContext)
                startMdnsService(serviceName, searchdevcb);
            else {
                comfunc.failureCBmDNS(MDNSErrCode.CONTEXT_CODE, MDNSErrCode.CONTEXT, searchdevcb);
            }
        } else {
            comfunc.failureCBmDNS(MDNSErrCode.EMPTY_CODE, MDNSErrCode.EMPTY, searchdevcb);
        }
    }

    /**
     * Stop search devices.
     *
     * @param searchdevcb searchdevcb
     */
    public void stopSearchDevices(SearchDeviceCallBack searchdevcb) {
        stopMdnsService(searchdevcb);
    }

    private void startMdnsService(String serviceName, final SearchDeviceCallBack searchdevcb) {
        mserviceName = serviceName;
        msearchdevcb = searchdevcb;

        // if is not started, then start, or callback
        if (!isWorking) {
            isWorking = true;

            if (wifiManager == null)
                wifiManager = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);

            // start Thread, stop after 3s, then open again, ande send message to app
            new Thread() {
                @Override
                public void run() {

                    stopMDNS();
                    startMDNS();

                    while (isWorking) {
                        try {
                            Thread.sleep(1000 * 3);
                            sendCallBack();
                        } catch (InterruptedException e) {
                            comfunc.successCBmDNS(MDNSErrCode.EXCEPTION_CODE, e.getMessage(), searchdevcb);
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        } else {
            comfunc.failureCBmDNS(MDNSErrCode.BUSY_CODE, MDNSErrCode.BUSY, searchdevcb);
        }
    }

    private void stopMdnsService(SearchDeviceCallBack searchdevcb) {
        if (isWorking) {
            isWorking = false;
            comfunc.successCBmDNS(MDNSErrCode.SUCCESS_CODE, MDNSErrCode.SUCCESS, searchdevcb);
        } else {
            comfunc.failureCBmDNS(MDNSErrCode.CLOSED_CODE, MDNSErrCode.CLOSED, searchdevcb);
        }
    }

    private void startMDNS() {
        new Thread() {
            @Override
            public void run() {


                jmdns = null;
                slistener = null;

                InetAddress intf = null;
                WifiManager.MulticastLock lock;

                array = new JSONArray();
                jsonmap = new HashMap<String, JSONObject>();

                try {
                    boolean jmdnsTag = true;
                    while (jmdnsTag) {
                        if (intf != null && jmdns != null) {
                            jmdnsTag = false;

                            lock = wifiManager.createMulticastLock("mylock");
                            lock.setReferenceCounted(true);
                            lock.acquire();

                            slistener = new SampleListener();
                            jmdns.addServiceListener(mserviceName, slistener);

                        } else {
                            if (intf == null) {
                                intf = getLocalIpAddress(mContext);
                            }

                            if (jmdns == null) {
                                jmdns = JmDNS.create(intf);
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void stopMDNS() {
        if (null != jmdns) {
            try {
                jmdns.removeServiceListener(mserviceName, slistener);
                jmdns.unregisterAllServices();
                jmdns.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateMessage() {

        JSONArray tmpArray = new JSONArray();
        Iterator it = jsonmap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            tmpArray.put(entry.getValue());
        }
        this.array = tmpArray;
    }

    private void sendCallBack() {
        comfunc.onDevsFindmDNS(array, msearchdevcb);
    }

    class SampleListener implements ServiceListener {
        ServiceInfo sName;

        @Override
        public void serviceAdded(ServiceEvent event) {
            if (!jsonmap.containsKey(event.getName())) {

                sName = jmdns.getServiceInfo(mserviceName, event.getName());
                if (null != sName) {

                    ArrayList<String> mDNSList = new ArrayList();

                    byte[] allinfobyte = sName.getTextBytes();
                    int allLen = allinfobyte.length;
                    for (int index = 0; index < allLen; ) {

                        int infoLength = allinfobyte[index++];
                        byte[] temp = new byte[infoLength];
                        System.arraycopy(allinfobyte, index, temp, 0,
                                infoLength);

                        try {
                            String isoString = new String(temp, "UTF-8");
                            mDNSList.add(isoString);
                            // Log.d(TAG + "arraycopy", isoString);
                        } catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }

                        index += infoLength;
                    }

                    try {
                        JSONObject jsonObject = new JSONObject();

                        String dev_ip = "";
                        // sName.getHostAddresses()
                        Inet4Address[] ipv4 = sName.getInet4Addresses();
                        if (ipv4.length > 0) {
                            dev_ip = ipv4[0].toString();

                            int isOtherStr = dev_ip.indexOf("/");
                            if (isOtherStr > -1) {
                                dev_ip = dev_ip.substring(isOtherStr + 1);
                            }
                        }

                        jsonObject.put("Name", sName.getName());
                        jsonObject.put("IP", dev_ip);
                        jsonObject.put("Port", sName.getPort());

                        for (String orlValue : mDNSList) {
                            if (!"".equals(orlValue)) {
                                String[] temp = orlValue.split("=");
                                jsonObject.put(temp[0], temp[1]);
                            }
                        }
                        jsonmap.put(event.getName(), jsonObject);

                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Message msg = new Message();
                    msg.what = _ADDDEVICE;
                    mdnsHandler.sendMessage(msg);
                }
            }
        }

        @Override
        public void serviceRemoved(ServiceEvent event) {
            jsonmap.remove(event.getName());
            Message msg = new Message();
            msg.what = _REMOVEDEVICE;
            mdnsHandler.sendMessage(msg);
        }

        @Override
        public void serviceResolved(ServiceEvent event) {

        }
    }

    private Handler mdnsHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case _ADDDEVICE:
                    updateMessage();
                    break;
                case _REMOVEDEVICE:
                    updateMessage();
                    break;
            }
        }
    };

    public InetAddress getLocalIpAddress(Context context) throws Exception {
        if (wifiManager == null)
            wifiManager = (WifiManager) context
                    .getSystemService(Context.WIFI_SERVICE);
        WifiInfo wifiinfo = wifiManager.getConnectionInfo();
        int intaddr = wifiinfo.getIpAddress();
        byte[] byteaddr = new byte[]{(byte) (intaddr & 0xff),
                (byte) (intaddr >> 8 & 0xff), (byte) (intaddr >> 16 & 0xff),
                (byte) (intaddr >> 24 & 0xff)};
        InetAddress addr = InetAddress.getByAddress(byteaddr);
        return addr;
    }

}