package io.fogcloud.fog_mqtt.api;

import android.content.Context;

import io.fogcloud.fog_mqtt.helper.ComHelper;
import io.fogcloud.fog_mqtt.helper.ConstParams;
import io.fogcloud.fog_mqtt.helper.ListenDeviceCallBack;
import io.fogcloud.fog_mqtt.helper.ListenDeviceParams;
import io.fogcloud.fog_mqtt.service.MqttServiceAPI;
import io.fogcloud.fog_mqtt.service.MqttServiceListener;


/**
 * 
 * @author Rocke by 2015-08-24
 * 
 */
public class MQTT {
	private MqttServiceAPI micomqtt;
	private Context mContext;
	
	//is mqtt working
	private boolean isWorking = false;

	public MQTT(Context context) {
		micomqtt = new MqttServiceAPI();
		this.mContext = context;
	}

	/**
	 * connect the mqtt server
	 * 
	 * @param listendevparams the paraments of listener
	 * @param ctrldevcb listen the callback
	 */
	public void startListenDevice(ListenDeviceParams listendevparams,
			final ListenDeviceCallBack ctrldevcb) {
		String topic = listendevparams.topic;
		String host = listendevparams.host;
		String userName = listendevparams.userName;
		String passWord = listendevparams.passWord;
		String clientID = listendevparams.clientID;
		boolean isencrypt = listendevparams.isencrypt;

		if (ComHelper.checkPara(topic, host, userName, passWord, clientID)) {
			if(!isWorking){
				isWorking = true;
				String port = listendevparams.port;
//				if (ComHelper.checkPara(port)) {
					if (null != mContext) {
						micomqtt.startMqttService(mContext, host, port,
								userName, passWord, clientID, topic, isencrypt,
								new MqttServiceListener() {
									@Override
									public void onMqttReceiver(int code, String messages) {
										ComHelper.onDevStatusReceived(code, messages, ctrldevcb);
									}
								});
	
						ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
					} else {
						ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.CONTEXTISNULL, ctrldevcb);
					}
//				} else {
//					ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
//				}
			}else{
				ComHelper.failureCBCtrlDev(ConstParams.ISWORKINGCODE, ConstParams.ISWORKING, ctrldevcb);
			}
		} else {
			ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
		}
	}

	/**
	 * send command
	 * @param topic topics
	 * @param command the command to the device
	 * @param qos 012
	 * @param retained 0
	 * @param ctrldevcb listen the callback
	 */
	public void sendCommand(String topic, 
			String command, 
			int qos,
			boolean retained, 
			final ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic, command)) {
				if(0 == qos|| 1 == qos || 2 == qos){
					micomqtt.publishCommand(topic, command, qos, retained);
				}else{
					ComHelper.failureCBCtrlDev(ConstParams.QOSERRCODE, ConstParams.QOSERR, ctrldevcb);
					return;
				}
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}

	/**
	 * add topic
	 * @param topic topics
	 * @param qos 0 1 2
	 * @param ctrldevcb listen the callback
	 */
	public void addDeviceListener(String topic, int qos, ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic)) {
				if(0 == qos|| 1 == qos || 2 == qos){
					micomqtt.subscribe(topic, qos);
					ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
				} else {
					ComHelper.failureCBCtrlDev(ConstParams.QOSERRCODE, ConstParams.QOSERR, ctrldevcb);
					return;
				}
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}

	/**
	 * remove the topic
	 * @param topic topics
	 * @param ctrldevcb listen the callback
	 */
	public void removeDeviceListener(String topic, ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic)) {
				micomqtt.unsubscribe(topic);
				ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}

	/**
	 * close the connect
	 * @param ctrldevcb listen the callback
	 */
	public void stopListenDevice(ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			isWorking = false;
			if (null != mContext) {
				micomqtt.stopMqttService(mContext);
				ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.CONTEXTISNULL, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}
}
