package io.fogcloud.mqtt.api;

import android.content.Context;

import io.fogcloud.mqtt.helper.ComHelper;
import io.fogcloud.mqtt.helper.ConstParams;
import io.fogcloud.mqtt.helper.ListenDeviceCallBack;
import io.fogcloud.mqtt.helper.ListenDeviceParams;
import io.fogcloud.mqtt.service.MqttServiceAPI;
import io.fogcloud.mqtt.service.MqttServiceListener;


/**
 * 
 * @author Rocke by 2015-08-24
 * 
 */
public class MQTT {
	private MqttServiceAPI micomqtt;
	private Context mContext;
	
	//MQTT是否已经启动
	private boolean isWorking = false;

	public MQTT(Context context) {
		micomqtt = new MqttServiceAPI();
		this.mContext = context;
	}

	/**
	 * 建立连接
	 * 
	 * @param listendevparams
	 * @param ctrldevcb
	 */
	public void startListenDevice(ListenDeviceParams listendevparams,
			final ListenDeviceCallBack ctrldevcb) {
		String topic = listendevparams.topic;
		String host = listendevparams.host;
		String userName = listendevparams.userName;
		String passWord = listendevparams.passWord;
		String clientID = listendevparams.clientID;
		boolean isencrypt = listendevparams.isencrypt;

		if (ComHelper.checkPara(topic, host, userName, passWord, clientID)) {
			if(!isWorking){
				isWorking = true;
				String port = listendevparams.port;
//				if (ComHelper.checkPara(port)) {
					if (null != mContext) {
						micomqtt.startMqttService(mContext, host, port,
								userName, passWord, clientID, topic, isencrypt,
								new MqttServiceListener() {
									@Override
									public void onMqttReceiver(int code, String messages) {
										ComHelper.onDevStatusReceived(code, messages, ctrldevcb);
									}
								});
	
						ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
					} else {
						ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.CONTEXTISNULL, ctrldevcb);
					}
//				} else {
//					ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
//				}
			}else{
				ComHelper.failureCBCtrlDev(ConstParams.ISWORKINGCODE, ConstParams.ISWORKING, ctrldevcb);
			}
		} else {
			ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
		}
	}

	/**
	 * send command
	 * @param topic
	 * @param command
	 * @param qos
	 * @param retained
	 * @param ctrldevcb
	 */
	public void sendCommand(String topic, 
			String command, 
			int qos,
			boolean retained, 
			final ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic, command)) {
				if(0 == qos|| 1 == qos || 2 == qos){
					micomqtt.publishCommand(topic, command, qos, retained);
				}else{
					ComHelper.failureCBCtrlDev(ConstParams.QOSERRCODE, ConstParams.QOSERR, ctrldevcb);
					return;
				}
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}

	/**
	 * 增加订阅
	 * @param topic
	 * @param qos
	 * @param ctrldevcb
	 */
	public void addDeviceListener(String topic, int qos, ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic)) {
				if(0 == qos|| 1 == qos || 2 == qos){
					micomqtt.subscribe(topic, qos);
					ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
				} else {
					ComHelper.failureCBCtrlDev(ConstParams.QOSERRCODE, ConstParams.QOSERR, ctrldevcb);
					return;
				}
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}

	/**
	 * 删除订阅
	 * @param topic
	 * @param ctrldevcb
	 */
	public void removeDeviceListener(String topic, ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic)) {
				micomqtt.unsubscribe(topic);
				ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}

	/**
	 * 关闭连接
	 * @param ctrldevcb
	 */
	public void stopListenDevice(ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			isWorking = false;
			if (null != mContext) {
				micomqtt.stopMqttService(mContext);
				ComHelper.successCBCtrlDev(ConstParams.SUCCESS, ctrldevcb);
			} else {
				ComHelper.failureCBCtrlDev(ConstParams.EMPTYCODE, ConstParams.CONTEXTISNULL, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(ConstParams.ALREADYSTOPCODE, ConstParams.ALREADYSTOP, ctrldevcb);
		}
	}
}
