package io.fogcloud.fog2.helper;

import com.lidroid.xutils.HttpUtils;
import com.lidroid.xutils.exception.HttpException;
import com.lidroid.xutils.http.RequestParams;
import com.lidroid.xutils.http.ResponseInfo;
import com.lidroid.xutils.http.callback.RequestCallBack;
import com.lidroid.xutils.http.client.HttpRequest;

import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;

/**
 * Created by Sin on 2016/07/27.
 * Email:88635653@qq.com
 */
public class FogHttpUtils {

    public void doGet(String httpsUrl, String param, String... jwt) {
        HttpUtils http = new HttpUtils();
        http.configTimeout(15000);

        RequestParams params = new RequestParams();
        params.addHeader("Content-Type", "application/json");
        if (jwt.length > 0) {
            params.addHeader("Authorization", "JWT " + jwt[0]);
        }
        httpsUrl += param;

        http.send(HttpRequest.HttpMethod.GET,
                httpsUrl,
                new RequestCallBack<String>() {
                    @Override
                    public void onLoading(long total, long current, boolean isUploading) {
                    }

                    @Override
                    public void onSuccess(ResponseInfo<String> responseInfo) {
                    }

                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void onFailure(HttpException error, String msg) {
                    }
                });
    }

    public void doPost(String httpsUrl, JSONObject param, String... jwt) {
        HttpUtils http = new HttpUtils();
        http.configTimeout(15000);

        RequestParams params = new RequestParams();
        params.addHeader("Content-Type", "application/json");
        if (jwt.length > 0) {
            params.addHeader("Authorization", "JWT " + jwt[0]);
        }

        // params.addHeader("name", "value");
        // params.addQueryStringParameter("name", "value");

        // 只包含字符串参数时默认使用BodyParamsEntity，
        // 类似于UrlEncodedFormEntity（"application/x-www-form-urlencoded"）。
        //  params.addBodyParameter("name", "value");

        // 加入文件参数后默认使用MultipartEntity（"multipart/form-data"），
        // 如需"multipart/related"，xUtils中提供的MultipartEntity支持设置subType为"related"。
        // 使用params.setBodyEntity(httpEntity)可设置更多类型的HttpEntity（如：
        // MultipartEntity,BodyParamsEntity,FileUploadEntity,InputStreamUploadEntity,StringEntity）。
        // params.addBodyParameter("file", new File("path"));
        // 例如发送json参数：
        try {
            params.setBodyEntity(new StringEntity(param.toString(), "UTF-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        http.send(HttpRequest.HttpMethod.POST,
                httpsUrl,
                params,
                new RequestCallBack<String>() {

                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void onLoading(long total, long current, boolean isUploading) {
                    }

                    @Override
                    public void onSuccess(ResponseInfo<String> responseInfo) {
                    }

                    @Override
                    public void onFailure(HttpException error, String msg) {
                    }
                });
    }
}
