package io.fogcloud.sdk.fog.helper;

import io.fogcloud.sdk.fog.callback.ControlDeviceCallBack;
import io.fogcloud.sdk.fog.callback.FogCallBack;
import io.fogcloud.sdk.fog.callback.ManageDeviceCallBack;
import io.fogcloud.sdk.fog.callback.SinSocketCallBack;

/**
 * Many javas will use this function Project：MiCOSDK Author：Sin Creat time
 * 2016-01-20
 * 
 * @version 1.0
 */
public class CommonFunc {
	
	/**
	 * Check argument, whether it is null or blank
	 * 
	 * @param param
	 * @return
	 */
	public boolean checkPara(String... param) {
		if (null == param || param.equals("")) {
			return false;
		} else if (param.length > 0) {
			for (String str : param) {
				if (null == str || str.equals("")) {
					return false;
				}
			}
			return true;
		}
		return false;
	}

	/**
	 * This field may not be blank
	 * 
	 * @param usercb
	 */
	public void illegalCallBack(FogCallBack usercb) {
		failureCBFilterUser(MiCOConstParam.EMPTYCODE, MiCOConstParam.EMPTY, usercb);
	}

	/**
	 * Success for user,
	 * Check if we will call back to the developer.
	 *
	 * @param message message
	 * @param usercb
	 */
	public void succeesCBFilterUser(String message, FogCallBack usercb) {
		if (null == usercb)
			return;
		usercb.onSuccess(message);
	}
	public void failureCBFilterUser(int code, String message, FogCallBack usercb) {
		if (null == usercb)
			return;
		usercb.onFailure(code, message);
	}

	/**
	 * Share my QRcode to developer.
	 * @param message message
	 * @param managedevcb managedevcb
	 */
	public void successCBShareQrCode(String message, ManageDeviceCallBack managedevcb){
		if (null == managedevcb)
			return;
		managedevcb.onSuccess(message);
	}
	public void failureCBShareQrCode(int code, String message, ManageDeviceCallBack managedevcb) {
		if (null == managedevcb)
			return;
		managedevcb.onFailure(code, message);
	}
	
	/**
	 * Share my QRcode to developer.
	 * @param message message
	 * @param managedevcb managedevcb
	 */
	public void successCBBindDev(String message, ManageDeviceCallBack managedevcb){
		if (null == managedevcb)
			return;
		managedevcb.onSuccess(message);
	}
	public void failureCBBindDev(int code, String message, ManageDeviceCallBack managedevcb) {
		if (null == managedevcb)
			return;
		managedevcb.onFailure(code, message);
	}
	
	/**
	 * Listen to my device.
	 * @param message message
	 * @param ctrldevcb
	 */
	public void successCBCtrlDev(String message, ControlDeviceCallBack ctrldevcb){
		if (null == ctrldevcb)
			return;
		ctrldevcb.onSuccess(message);
	}
	public void failureCBCtrlDev(int code, String message, ControlDeviceCallBack ctrldevcb) {
		if (null == ctrldevcb)
			return;
		ctrldevcb.onFailure(code, message);
	}
	public void onDevStatusReceived(int code, String messages, ControlDeviceCallBack ctrldevcb){
		if (null == ctrldevcb)
			return;
		ctrldevcb.onDeviceStatusReceived(code, messages);
	}
	
	/**
	 * Local control device.
	 * @param message message
	 * @param sscb sscb
	 */
	public void successCBLocalCtrl(String message, SinSocketCallBack sscb){
		if (null == sscb)
			return;
		sscb.onSuccess(message);
	}
	
	public void failureCBLocalCtrl(int code, String message, SinSocketCallBack sscb){
		if (null == sscb)
			return;
		sscb.onFailure(code, message);
	}
	
	public void lostCBLocalCtrl(SinSocketCallBack sscb){
		if (null == sscb)
			return;
		sscb.onLost();
	}
	
	public void msgReadCBLocalCtrl(String message, SinSocketCallBack sscb){
		if (null == sscb)
			return;
		sscb.onMessageRead(message);
	}
}
