package io.fogcloud.sdk.fog.api;

import org.json.JSONException;
import org.json.JSONObject;

import io.fogcloud.sdk.fog.callback.FogCallBack;
import io.fogcloud.sdk.fog.helper.CommonFunc;
import io.fogcloud.sdk.fog.helper.Configuration;
import io.fogcloud.sdk.fog.httputils.HttpSendParam;

/**
 * Account's implements, includes login, register...
 * Project:MiCOSDK
 * Author:Sin
 * Create time:20160120
 *
 * @version 3.0
 */
public class FogUser {

    private HttpSendParam hsp = new HttpSendParam();
    private CommonFunc comfunc = new CommonFunc();

    /**
     * Get phone verify code.
     *
     * @param loginname
     * @param appid
     * @param micocb
     */
    public void getVerifyCode(String loginname, String appid, FogCallBack micocb) {
        if (comfunc.checkPara(loginname, appid)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("loginname", loginname);
                postParam.put("appid", appid);
                hsp.doHttpPost(Configuration.GETVERCODE(), postParam, micocb);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }

    /**
     * Vrify phone SMS code.
     *
     * @param loginname
     * @param vercode
     * @param appid
     * @param micocb
     */
    public void checkVerifyCode(String loginname, String vercode, String appid, FogCallBack micocb) {
        if (comfunc.checkPara(loginname, vercode, appid)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("loginname", loginname);
                postParam.put("vercode", vercode);
                postParam.put("appid", appid);
                hsp.doHttpPost(Configuration.CHECKVERCODE(), postParam, micocb);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }

    /**
     * Register my account to fogcloud,
     * set my initial password
     *
     * @param password
     * @param micocb
     * @param token
     */
    public void setPassword(String password, FogCallBack micocb, String token) {
        if (comfunc.checkPara(password, token)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("password1", password);
                postParam.put("password2", password);
                hsp.doHttpPost(Configuration.RESETPASSWORD(), postParam, micocb, token);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }

    /**
     * Login my account.
     *
     * @param loginname
     * @param password
     * @param appid
     * @param micocb
     */
    public void login(String loginname, String password, String appid,
                      FogCallBack micocb) {
        if (comfunc.checkPara(loginname, password, appid)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("loginname", loginname);
                postParam.put("password", password);
                postParam.put("appid", appid);
                hsp.doHttpPost(Configuration.LOGININ(), postParam, micocb);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }

    /**
     * Refresh my token, and let it delay another 7 days.
     *
     * @param token
     * @param micocb
     */
    public void refreshToken(String token, FogCallBack micocb) {
        if (comfunc.checkPara(token)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("token", token);
                hsp.doHttpPost(Configuration.REFRESHTOKEN(), postParam, micocb);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }

    /**
     * Check my token.
     *
     * @param token
     * @param micocb
     */
    public void verifyToken(String token, FogCallBack micocb) {
        if (comfunc.checkPara(token)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("token", token);
                hsp.doHttpPost(Configuration.VERIFYTOKEN(), postParam,
                        micocb);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }

    /**
     * Forget my password, and reset it.
     *
     * @param password
     * @param token
     * @param micocb
     */
    public void resetPassword(String password, FogCallBack micocb, String token) {
        if (comfunc.checkPara(password, token)) {
            JSONObject postParam = new JSONObject();
            try {
                postParam.put("password1", password);
                postParam.put("password2", password);
                hsp.doHttpPost(Configuration.RESETPASSWORD(), postParam, micocb, token);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            comfunc.illegalCallBack(micocb);
        }
    }
}
