package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceRequest;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.net.UnknownHostException;
import io.fogcloud.sdk.easylink.helper.*;

/**
 * Created by youxiaoxiang on 2017/11/7.
 */
public class EasylinkP2P {
    private Context mContext;// 上下文

    private WifiP2pManager manager;
    private WifiP2pDnsSdServiceRequest serviceRequest;
    private WifiP2pManager.Channel channel;
    private aws_broadcast aws;
    private boolean threadtag = true;
    private final int d_port = 65123;
    private static boolean close_flag = false;
    private static boolean close_AWS_Listen_flag = false;
    private String chanelname;
    private EasyLinkCallBack elcb;

    public EasylinkP2P(Context mContext_e) {
        mContext = mContext_e;
        manager = (WifiP2pManager) mContext.getSystemService(Context.WIFI_P2P_SERVICE);
        channel = manager.initialize(mContext, mContext.getMainLooper(), new WifiP2pManager.ChannelListener() {
            @Override
            public void onChannelDisconnected() {
            }
        });

        /*发送定位包*/
        send2handler(1, "");
        aws = new aws_broadcast();
    }

    private void sendTargetPack() {
        new Thread() {
            final int d_port = 50000;
            @Override
            public void run() {
                UdpSend tt = new UdpSend();
                while (threadtag) {
                    try {
                        tt.sendConfigData(0x4E0, d_port);
                        Thread.sleep(20);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void listenModulepack() {
        new Thread() {
            public void run() {
                byte[] buf = new byte[1024];
                UdpSend tt = new UdpSend(d_port);
                DatagramPacket recvdata = new DatagramPacket(buf,1024);
                while (close_AWS_Listen_flag == false) {
                    try{
                        tt.recvPackage(recvdata);
                        if( recvdata.getLength() != 0 )
                        {
                            if(close_flag == false) {
                            /*关闭配网*/
                                close_flag = true;
                                clearService();
                                aws.set_stop_broad_flag(true);
                            }
                            elcb.onSuccess(0,new String(recvdata.getData()));
                            Log.w("yyy",new String(recvdata.getData(),0,recvdata.getLength()));
                            send2handler(2,new String(recvdata.getData(),0,recvdata.getLength()));
                            /*向模块发送单播回包*/
                            tt.sendUdpunicast(recvdata.getData(),recvdata.getLength(),recvdata.getPort(),recvdata.getAddress());
                        }
                        Thread.sleep(20);
                    }catch(InterruptedException | SocketException | UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void discoverService() {

        serviceRequest = WifiP2pDnsSdServiceRequest.newInstance();
        manager.addServiceRequest(channel, serviceRequest,
                null);
        manager.discoverServices(channel, null);
    }

    private void clearService() {

        manager.clearLocalServices(channel,null);
        manager.clearServiceRequests(channel,new WifiP2pManager.ActionListener() {

            @Override
            public void onSuccess() {
//                Toast.makeText(mContext, "stop easylink", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onFailure(int reason) {
//                Toast.makeText(mContext, "关闭配网失败", Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void clearService(final EasyLinkCallBack easylinkcb) {

        clearName();
        manager.clearLocalServices(channel,null);
        manager.clearServiceRequests(channel,new WifiP2pManager.ActionListener() {
            @Override
            public void onSuccess() {

//                Toast.makeText(mContext, "stop easylink", Toast.LENGTH_SHORT).show();
                easylinkcb.onSuccess(0,new String("stop easylink success"));
            }

            @Override
            public void onFailure(int reason) {
//                Toast.makeText(mContext, "关闭配网失败", Toast.LENGTH_SHORT).show();
                easylinkcb.onFailure(1,new String("stop easylink failed"));
            }
        });
    }

    private void clearName() {
                new Thread() {
            @Override
            public void run() {
                try {
                    //清空名字
                    chanelname = "Android_Easy";
                    Class<?> partypes[] = new Class[3];
                    partypes[0] = WifiP2pManager.Channel.class;
                    partypes[1] = String.class;
                    partypes[2] = WifiP2pManager.ActionListener.class;
                    Method method = manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);

                    threadtag = false;
                    close_flag = false;

                    Object[] args = new Object[3];
                    args[0] = channel;
                    args[1] = chanelname;
                    args[2] = new WifiP2pManager.ActionListener() {

                        @Override
                        public void onSuccess() {
                        }

                        @Override
                        public void onFailure(int reason) {
                        }
                    };
                    method.invoke(manager, args);

                    discoverService();
                } catch (NoSuchMethodException | IllegalArgumentException | IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getData(String Ssid, String Key) {
        String param = null;
        try {
            param = new P2PData().bgProtocol(aws,Ssid, Key);
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return param;
    }

    public void startEasyLink(final EasyLinkParams elp, EasyLinkCallBack easylinkcb) {

        elcb = easylinkcb;
        aws.set_stop_broad_flag(false);
        chanelname = getData(elp.ssid,elp.password);

        new Thread() {
            @Override
            public void run() {
                try {
                    Class<?> partypes[] = new Class[3];
                    partypes[0] = WifiP2pManager.Channel.class;
                    partypes[1] = String.class;
                    partypes[2] = WifiP2pManager.ActionListener.class;
                    Method method = manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);

                    threadtag = false;
                    close_flag = false;

                    Object[] args = new Object[3];
                    args[0] = channel;
                    args[1] = chanelname;
                    args[2] = new WifiP2pManager.ActionListener() {

                        @Override
                        public void onSuccess() {
//                            elcb.onSuccess(0,"success");
                        }

                        @Override
                        public void onFailure(int reason) {
                            elcb.onFailure(1,"failed");
                        }
                    };
                    method.invoke(manager, args);

                    discoverService();
                } catch (NoSuchMethodException | IllegalArgumentException | IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void stopEasyLink(EasyLinkCallBack easylinkcb)
    {
        clearService(easylinkcb);
        close_AWS_Listen_flag = true;
        aws.set_stop_broad_flag(true);
    }

    private void send2handler(int code, String message) {
        Message msg = new Message();
        msg.what = code;
        msg.obj = message;
        LHandler.sendMessage(msg);
    }

    Handler LHandler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            /*p2p*/
            /*定位包,监听udp*/
            if (msg.what == 1) {
                sendTargetPack();
                listenModulepack();
            }
        }
    };
}
