package io.fogcloud.sdk.easylink.helper;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by youxiaoxiang on 2017/10/31.
 */
public class aws_broadcast {

    //    private int s_port = 68;
    private int d_port = 50000;
    private boolean stop_broadcast = false;

    public void set_stop_broad_flag(boolean flag)
    {
        stop_broadcast = flag;
    }

    public boolean isContainChinese(String str) {

        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            return true;
        } else {
            return false;
        }
    }

    /*
 * 8bit -> 6bit
 *
 * serialize chinese char from 8bit to 6bit
 */
    private static char encode_chinese(char[] in, char in_len, char[] out) {
        char bit[] = new char[33 * 8];
        char i, j;
        int output_len = ((in_len * 8) + 5) / 6;

        //char to bit stream
        for (i = 0; i < in_len; i++) {
            for (j = 0; j < 8; j++) {
                bit[i * 8 + j] = (char) ((in[i] >> j) & 0x01);
            }
        }

        out[output_len] = '\0'; /* NULL-terminated */
        for (i = 0; i < output_len; i++) {
            for (j = 0, out[i] = 0; j < 6; j++) {
                out[i] |= bit[i * 6 + j] << j;
            }
        }
        return (char) output_len;

//        if (out_len) {
//            *out_len = output_len;
//        }
    }

    private static char zconfig_checksum(char[] data, int len) {
        char i;
        int sum = 0, res;

        for (i = 0; i < len; i++) {
            sum += data[i];
        }

        res = sum & (0x7F << 0);
        res |= (sum & (0x7F << 7)) << 1;


        return (char) res;
    }

    public void aws_send(final String ssid, final String key) {

        new Thread() {
            @Override
            public void run() {
                UdpSend tt = new UdpSend();
                char total_len, ssid_len, key_len;
                char encoded_ssid[] = new char[33];
                char payload[] = new char[100];
                char hi;
                int i = 0, j;
                char crc;
                int ssid_is_assic = 0;
                char[] ssid_array; //创建一个字符数组chrCharArray
                char[] key_array;
                ssid_array = ssid.toCharArray(); //将字符串变量转换为字符数组
                key_array = key.toCharArray();

                ssid_len = 0;

        /*判断ssid是否含有中文*/
                if (isContainChinese(ssid)) {
                    ssid_is_assic = 0;
                } else {
                    ssid_is_assic = 1;
                }
        /*全是ascii码*/
                if (ssid_is_assic == 1) {
                    ssid_len = (char) ssid_array.length;
                    for (int ssid_count = 0; ssid_count < ssid_len; ssid_count++) {
                        encoded_ssid[ssid_count] = (char) (ssid_array[ssid_count] - 0x20);
                    }
                } else {
                    ssid_len = encode_chinese(ssid_array, ssid_len, encoded_ssid); // 对中文编码作encode计算
                }
                key_len = (char) key_array.length;

                total_len = (char) (1 + 1 + 1 + 1 + ssid_len + key_len + 2); // total flag ssidlen keylen ssid key crc
                payload[i++] = total_len;
                if (ssid_is_assic == 1)
                    payload[i++] = 1; // flag = 1
                else
                    payload[i++] = 0x21; // flag = 0x21, 中文


                payload[i++] = ssid_len;
                payload[i++] = key_len;

                for (j = 0; j < ssid_len; j++) {
                    payload[i++] = encoded_ssid[j];
                }
                for (j = 0; j < key_len; j++) {
                    payload[i++] = (char) (key_array[j] - 0x20);
                }

                crc = zconfig_checksum(payload, total_len - 2);

//                payload[i++] = (char) ((crc & 0x7F) >> 8); // big endian
                payload[i++] = (char) ((crc & 0xff00) >> 8);
                payload[i++] = (char) (crc & 0x7F);

                for (j = 0; j < total_len; j++) {
                    hi = (char) (((j % 8) + 2) << 7);
                    payload[j] += hi;
                }

                while (stop_broadcast == false) {
                    try {
                        /*header*/
                        d_port = 50000;
                        tt.sendConfigData(0x4E0, d_port++);
                        tt.sendConfigData(0x4E0, d_port++);
                        tt.sendConfigData(0x4E0, d_port++);
                        j = 1;
                        for (i = 0; i < total_len; i++) {
                            tt.sendConfigData(payload[i], d_port++);
                            if ((i % 8) == 7) {
                                tt.sendConfigData(j + 0x3E0, d_port++); // group number
                                tt.sendConfigData(j + 0x3E0, d_port++); // group number
                                j++;
                            }
                        }
                    } catch (SocketException | UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.run();
    }
}
