package io.fogcloud.sdk.easylink.api;

import android.content.Context;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceRequest;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.net.UnknownHostException;
import io.fogcloud.sdk.easylink.helper.*;

/**
 * Created by youxiaoxiang on 2017/11/7.
 */
public class EasylinkP2P {
    private Context mContext;// 上下文

    private WifiP2pManager manager;
    private WifiP2pDnsSdServiceRequest serviceRequest;
    private WifiP2pManager.Channel channel;
    private aws_broadcast aws;
    private boolean threadtag = true;
    private final int d_port = 65123;
    private static boolean close_flag = false;

    public EasylinkP2P(Context mContext_e) {
        mContext = mContext_e;
        manager = (WifiP2pManager) mContext.getSystemService(Context.WIFI_P2P_SERVICE);
        channel = manager.initialize(mContext, mContext.getMainLooper(), new WifiP2pManager.ChannelListener() {
            @Override
            public void onChannelDisconnected() {
                Toast.makeText(mContext, "onChannelDisconnected failed", Toast.LENGTH_LONG).show();
            }
        });

                /*发送定位包*/
        send2handler(1, "");
        aws = new aws_broadcast();
    }

    private void sendTargetPack() {
        new Thread() {
            final int d_port = 50000;
            @Override
            public void run() {
                UdpSend tt = new UdpSend();
                while (threadtag) {
                    try {
                        tt.sendConfigData(0x4E0, d_port);
                        Thread.sleep(20);
                    } catch (SocketException | UnknownHostException | InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void listenModulepack() {
        new Thread() {
            public void run() {
                byte[] buf = new byte[1024];
                UdpSend tt = new UdpSend(d_port);
                DatagramPacket recvdata = new DatagramPacket(buf,1024);
                while (true) {
                    try{
                        tt.recvPackage(recvdata);
                        if( recvdata.getLength() != 0 )
                        {
                            if(close_flag == false) {
                            /*关闭配网*/
                                close_flag = true;
                                clearService();
                                aws.set_stop_broad_flag(true);
                            }
                            elcb.onSuccess(0,new String(recvdata.getData()));

                            Log.w("yyy",new String(recvdata.getData(),0,recvdata.getLength()));
                            send2handler(2,new String(recvdata.getData(),0,recvdata.getLength()));
                            /*向模块发送单播回包*/
                            tt.sendUdpunicast(recvdata.getData(),recvdata.getLength(),recvdata.getPort(),recvdata.getAddress());
                        }
                        Thread.sleep(20);
                    }catch(InterruptedException | SocketException | UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void discoverService() {

        serviceRequest = WifiP2pDnsSdServiceRequest.newInstance();
        manager.addServiceRequest(channel, serviceRequest,
                null);
        manager.discoverServices(channel, null);
    }

    private void clearService() {

        manager.clearLocalServices(channel,null);
        manager.clearServiceRequests(channel,new WifiP2pManager.ActionListener() {

            @Override
            public void onSuccess() {
                Toast.makeText(mContext, "关闭配网", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onFailure(int reason) {
                Toast.makeText(mContext, "关闭配网失败", Toast.LENGTH_SHORT).show();
            }
        });
    }

    private String getData(String Ssid, String Key) {
        String param = null;
        try {
            param = new P2PData().bgProtocol(aws,Ssid, Key);
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }

        return param;
    }

    private EasyLinkCallBack elcb;
    public void startEasyLink(EasyLinkParams elp, EasyLinkCallBack easylinkcb) {

        elcb = easylinkcb;
        final String chanelname = getData(elp.ssid, elp.password);

        new Thread() {
            @Override
            public void run() {
                try {
                    Class<?> partypes[] = new Class[3];
                    partypes[0] = WifiP2pManager.Channel.class;
                    partypes[1] = String.class;
                    partypes[2] = WifiP2pManager.ActionListener.class;
                    Method method = manager.getClass().getMethod("setDeviceName", partypes);
                    method.setAccessible(true);

                    threadtag = false;
                    close_flag = false;

                    Object[] args = new Object[3];
                    args[0] = channel;
                    args[1] = chanelname;
                    args[2] = new WifiP2pManager.ActionListener() {

                        @Override
                        public void onSuccess() {
//                            elcb.onSuccess(0,"success");
                        }

                        @Override
                        public void onFailure(int reason) {
                            elcb.onFailure(1,"failed");
                        }
                    };
                    method.invoke(manager, args);

                    discoverService();
                } catch (NoSuchMethodException | IllegalArgumentException | IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void send2handler(int code, String message) {
        Message msg = new Message();
        msg.what = code;
        msg.obj = message;
        LHandler.sendMessage(msg);
    }

    Handler LHandler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            /*p2p*/
//            if (msg.what == 0) {
//                setDeviceName(getData(ssid.getText().toString(), password.getText().toString()));
//            }
            /*定位包,监听udp*/
            if (msg.what == 1) {
                sendTargetPack();
                listenModulepack();
            }
//            else if (msg.what == 2) {
//                if(countno >2){
//                    log_view.setText("");
//                    countno = 1;
//                }
//                log_view.append(msg.obj.toString().trim() + "\r\n");
//                countno ++;
//            }
        }
    };
}
