package io.fogcloud.easylink.api;

import java.net.NetworkInterface;
import java.net.SocketException;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import io.fogcloud.easylink.helper.ComHelper;
import io.fogcloud.easylink.helper.EasyLinkCallBack;
import io.fogcloud.easylink.helper.EasyLinkParams;
import io.fogcloud.easylink.helper.EasyLinkErrCode;

/**
 * Created by wangchao on 4/20/15.
 */
public class EasyLink {

    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private EasyLink_plus mEasylinkPlus;
    private boolean eltag = false;
    private Thread workThread = null;

    private ComHelper comfunc = new ComHelper();
    private Context mContext;

    public EasyLink(Context context){
        this.mContext = context;
    }

    /**
     * get ssid
     * @return the wifi router which you connected
     */
    public String getSSID() {
        mWifiManager = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);
        mWifiInfo = mWifiManager.getConnectionInfo();
        return mWifiInfo.getSSID().replaceAll("\"", "");
    }

    public void startEasyLink(EasyLinkParams easylinkPara, EasyLinkCallBack easylinkcb) {

        if (ComHelper.checkPara(easylinkPara.ssid)) {
            if(null != mContext)
                startEasyLink(
                        easylinkPara.ssid,
                        easylinkPara.password,
                        easylinkPara.isSendIP,
                        easylinkPara.runSecond,
                        easylinkPara.sleeptime,
                        easylinkPara.extraData,
                        easylinkPara.rc4key,
                        easylinkcb);
            else{
                comfunc.failureCBEasyLink(EasyLinkErrCode.CONTEXT_CODE, EasyLinkErrCode.CONTEXT,easylinkcb);
            }
        } else {
            comfunc.failureCBEasyLink(EasyLinkErrCode.INVALID_CODE, EasyLinkErrCode.INVALID,easylinkcb);
        }
    }

    /**
     * Start easylink
     * @param ssid
     * @param password
     * @param runSecond
     * @param sleeptime
     * @param extraData
     * @param rc4key
     * @param easylinkcb
     */
    private void startEasyLink(
            String ssid,
            String password,
            final boolean isSendIP,
            final int runSecond,
            final int sleeptime,
            final String extraData,
            String rc4key,
            final EasyLinkCallBack easylinkcb) {

        if (!eltag) {
            if (null == workThread) {
                workThread = new Thread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            Thread.sleep(runSecond);
                            if(eltag)
                                stopEasyLink(easylinkcb);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
                workThread.start();
            }

            try {
                startEasylink(ssid, password, isSendIP, sleeptime, extraData, rc4key, easylinkcb);
                eltag = true;
                comfunc.successCBEasyLink(EasyLinkErrCode.START_CODE, EasyLinkErrCode.SUCCESS, easylinkcb);
            } catch (Exception e) {
                comfunc.failureCBEasyLink(EasyLinkErrCode.EXCEPTION_CODE, e.getMessage(),easylinkcb);
            }
        } else {
            comfunc.failureCBEasyLink(EasyLinkErrCode.BUSY_CODE, EasyLinkErrCode.BUSY,easylinkcb);
        }
    }

    /**
     * Stop EasyLink
     * @param easylinkcb callback
     */
    public void stopEasyLink(EasyLinkCallBack easylinkcb) {
        if (null != mEasylinkPlus && eltag) {
            if (null != workThread) {
                workThread = null;
            }
            mEasylinkPlus.stopTransmitting();
            eltag = false;
            comfunc.successCBEasyLink(EasyLinkErrCode.STOP_CODE, EasyLinkErrCode.SUCCESS,easylinkcb);
        } else {
            comfunc.failureCBEasyLink(EasyLinkErrCode.CLOSED_CODE, EasyLinkErrCode.CLOSED,easylinkcb);
        }
    }

    protected void startEasylink(String ssid, String password, boolean isSendIP, int sleeptime, String extraData, String rc4key, EasyLinkCallBack easylinkcb) {
        // v2 and v3
        int ip = 0;
        // ip and extra or ip without extra
        if(isSendIP){
            ip = getNormalIP(mContext);
        }
        // only radom
        else if(ComHelper.isInteger(extraData)){
            ip = Integer.parseInt(extraData);
            extraData = "";
        }
        // only radom
        else{
            ip = 1000;
            extraData = "";
        }

        mEasylinkPlus = EasyLink_plus.getInstence(mContext);
        try {
            NetworkInterface intf = NetworkInterface.getByName("wlan0");
            if (intf.getMTU() < 1500) {
                mEasylinkPlus.setSmallMtu(true);
            }
        } catch (SocketException e) {
            e.printStackTrace();
            comfunc.failureCBEasyLink(EasyLinkErrCode.EXCEPTION_CODE, e.getMessage(),easylinkcb);
        }
        try {
            mEasylinkPlus.transmitSettings(ssid, password, ip, sleeptime, extraData, rc4key);
        } catch (Exception e) {
            e.printStackTrace();
            comfunc.failureCBEasyLink(EasyLinkErrCode.EXCEPTION_CODE, e.getMessage(),easylinkcb);
        }
    }

    private int getNormalIP(Context context) {
        mWifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        mWifiInfo = mWifiManager.getConnectionInfo();
        return mWifiInfo.getIpAddress();
    }
}