package io.fogcloud.easylink.api;

import java.net.NetworkInterface;
import java.net.SocketException;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import io.fogcloud.easylink.helper.ComHelper;
import io.fogcloud.easylink.helper.EasyLinkCallBack;
import io.fogcloud.easylink.helper.EasyLinkParams;
import io.fogcloud.easylink.helper.MiCOConstParam;

/**
 * Created by wangchao on 4/20/15.
 */
public class EasyLink {

    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private EasyLink_plus mEasylinkPlus;
    private boolean eltag = false;
    private Thread workThread = null;

    private ComHelper comfunc = new ComHelper();
    private Context mContext;

    public EasyLink(Context context){
        this.mContext = context;
    }

    /**
     * get ssid
     * @return the wifi router which you connected
     */
    public String getSSID() {
        mWifiManager = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);
        mWifiInfo = mWifiManager.getConnectionInfo();
        return mWifiInfo.getSSID().replaceAll("\"", "");
    }

    public void startEasyLink(EasyLinkParams easylinkPara, EasyLinkCallBack easylinkcb) {

        if (ComHelper.checkPara(easylinkPara.ssid)) {
            if(null != mContext)
                startEasyLink(
                        easylinkPara.ssid,
                        easylinkPara.password,
                        easylinkPara.runSecond,
                        easylinkPara.sleeptime,
                        easylinkPara.extraData,
                        easylinkPara.rc4key,
                        easylinkcb);
            else{
                comfunc.failureCBEasyLink(MiCOConstParam.EMPTYCODE, MiCOConstParam.CONTEXTISNULL,easylinkcb);
            }
        } else {
            comfunc.failureCBEasyLink(MiCOConstParam.EMPTYCODE, MiCOConstParam.EMPTY,easylinkcb);
        }
    }

    /**
     * Start easylink
     * @param ssid
     * @param password
     * @param runSecond
     * @param sleeptime
     * @param extraData
     * @param rc4key
     * @param easylinkcb
     */
    private void startEasyLink(
            String ssid,
            String password,
            final int runSecond,
            final int sleeptime,
            final String extraData,
            String rc4key,
            final EasyLinkCallBack easylinkcb) {

        if (!eltag) {
            if (null == workThread) {
                workThread = new Thread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            Thread.sleep(runSecond);
                            if(eltag)
                                stopEasyLink(easylinkcb);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
                workThread.start();
            }

            try {
                startEasylink(ssid, password, sleeptime, extraData, rc4key, easylinkcb);
                eltag = true;
                comfunc.successCBEasyLink(MiCOConstParam.START_CODE, MiCOConstParam.SUCCESS, easylinkcb);
            } catch (Exception e) {
                comfunc.failureCBEasyLink(MiCOConstParam.EXCEPTIONCODE, e.getMessage(),easylinkcb);
            }
        } else {
            comfunc.failureCBEasyLink(MiCOConstParam.ISWORKINGCODE, MiCOConstParam.ISWORKING,easylinkcb);
        }
    }

    /**
     * Stop EasyLink
     * @param easylinkcb callback
     */
    public void stopEasyLink(EasyLinkCallBack easylinkcb) {
        if (null != mEasylinkPlus && eltag) {
            if (null != workThread) {
                workThread = null;
            }
            mEasylinkPlus.stopTransmitting();
            eltag = false;
            comfunc.successCBEasyLink(MiCOConstParam.STOP_CODE, MiCOConstParam.STOP_SUCCESS,easylinkcb);
        } else {
            comfunc.failureCBEasyLink(MiCOConstParam.ALREADYSTOPCODE, MiCOConstParam.ALREADYSTOP,easylinkcb);
        }
    }

    protected void startEasylink(String ssid, String password, int sleeptime, String extraData, String rc4key, EasyLinkCallBack easylinkcb) {
        // v2 and v3
        int ip = getNormalIP(mContext);
        mEasylinkPlus = EasyLink_plus.getInstence(mContext);
        try {
            NetworkInterface intf = NetworkInterface.getByName("wlan0");
            if (intf.getMTU() < 1500) {
                mEasylinkPlus.setSmallMtu(true);
            }
        } catch (SocketException e) {
            e.printStackTrace();
            comfunc.failureCBEasyLink(MiCOConstParam.EXCEPTIONCODE, e.getMessage(),easylinkcb);
        }
        try {
            mEasylinkPlus.transmitSettings(ssid, password, ip, sleeptime, extraData, rc4key);
        } catch (Exception e) {
            e.printStackTrace();
            comfunc.failureCBEasyLink(MiCOConstParam.EXCEPTIONCODE, e.getMessage(),easylinkcb);
        }
    }

    private int getNormalIP(Context context) {
        mWifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        mWifiInfo = mWifiManager.getConnectionInfo();
        return mWifiInfo.getIpAddress();
    }
}