/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.domain;

import java.io.Serializable;
import java.util.ArrayList;

public class Permissions
implements Serializable {
    protected boolean administer;
    protected boolean read;
    protected boolean write;
    protected boolean dropRead;
    protected boolean dropWrite;
    public static final Permissions ALL = new Permissions(true, true, true, true, true);
    public static final Permissions NONE = new Permissions(false, false, false, false, false);
    public static final Permissions ADMIN = ALL;

    public Permissions() {
    }

    public Permissions(boolean read, boolean write, boolean dropRead, boolean dropWrite) {
        this(read, write, dropRead, dropWrite, false);
    }

    public static Permissions tokenPermissions(boolean dropRead, boolean dropWrite) {
        return new Permissions(true, false, dropRead, dropWrite);
    }

    protected Permissions(boolean read, boolean write, boolean dropRead, boolean dropWrite, boolean admister) {
        this.read = read;
        this.write = write;
        this.dropRead = dropRead;
        this.dropWrite = dropWrite;
        this.administer = admister;
    }

    public Permissions union(Permissions permissions) {
        if (permissions.administer || this.administer) {
            return ADMIN;
        }
        return new Permissions(this.canRead() || permissions.canRead(), this.canWrite() || permissions.canWrite(), this.canReadDrops() || permissions.canReadDrops(), this.canWriteDrops() || permissions.canWriteDrops());
    }

    public Permissions intersection(Permissions permissions) {
        if (permissions.administer && this.administer) {
            return permissions;
        }
        return new Permissions(this.canRead() && permissions.canRead(), this.canWrite() && permissions.canWrite(), this.canReadDrops() && permissions.canReadDrops(), this.canWriteDrops() && permissions.canWriteDrops());
    }

    public boolean canRead() {
        return this.read || this.administer;
    }

    public boolean canWrite() {
        return this.write || this.administer;
    }

    public boolean canReadDrops() {
        return this.dropRead || this.administer;
    }

    public boolean canWriteDrops() {
        return this.dropWrite || this.administer;
    }

    public boolean isAdministrator() {
        return this.administer;
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.read) {
            l.add("R");
        }
        if (this.write) {
            l.add("W");
        }
        if (this.dropRead) {
            l.add("DR");
        }
        if (this.dropWrite) {
            l.add("DW");
        }
        if (this.administer) {
            l.add("A");
        }
        return l.isEmpty() ? "<none>" : ((Object)l).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.administer ? 1231 : 1237);
        result = 31 * result + (this.dropRead ? 1231 : 1237);
        result = 31 * result + (this.dropWrite ? 1231 : 1237);
        result = 31 * result + (this.read ? 1231 : 1237);
        result = 31 * result + (this.write ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permissions other = (Permissions)obj;
        if (this.administer != other.administer) {
            return false;
        }
        if (this.dropRead != other.dropRead) {
            return false;
        }
        if (this.dropWrite != other.dropWrite) {
            return false;
        }
        if (this.read != other.read) {
            return false;
        }
        return this.write == other.write;
    }
}

