/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client;

import com.flowthings.client.domain.elements.Location;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class DropElementSerializer<T> {
    protected String[] typeKeys;
    protected static DropElementSerializer<Map<String, Object>> MAP = new DropElementSerializer<Map<String, Object>>(new String[]{"map", "sortedMap"}){

        private Map<String, Object> newInstance(String type) {
            if ("sortedMap".equals(type)) {
                return new TreeMap<String, Object>();
            }
            return new HashMap<String, Object>();
        }

        @Override
        protected String getTypeKey(Map<String, Object> o) {
            if (o instanceof SortedMap) {
                return "sortedMap";
            }
            return "map";
        }

        @Override
        public Map<String, Object> from(String type, JsonElement elem) {
            Map<String, Object> m = this.newInstance(type);
            JsonObject c = elem.getAsJsonObject();
            for (Map.Entry e : c.entrySet()) {
                m.put((String)e.getKey(), DropElementSerializer.fromJsonElement((JsonElement)e.getValue()));
            }
            return m;
        }

        public JsonObject toPrimitive(Map<String, Object> m) {
            JsonObject o = new JsonObject();
            for (Map.Entry<String, Object> e : m.entrySet()) {
                o.add(e.getKey(), 1.toJsonElement(e.getValue()));
            }
            return o;
        }
    };
    protected static DropElementSerializer<Collection<Object>> COLLECTION = new DropElementSerializer<Collection<Object>>(new String[]{"list", "set", "sortedSet"}){

        private Collection<Object> newInstance(String type) {
            if ("set".equals(type)) {
                return new HashSet<Object>();
            }
            if ("sortedSet".equals(type)) {
                return new TreeSet<Object>();
            }
            return new ArrayList<Object>();
        }

        @Override
        protected String getTypeKey(Collection<Object> o) {
            if (o instanceof SortedSet) {
                return "sortedSet";
            }
            if (o instanceof Set) {
                return "set";
            }
            return "list";
        }

        @Override
        public Collection<Object> from(String type, JsonElement elem) {
            Collection<Object> m = this.newInstance(type);
            for (JsonElement o : elem.getAsJsonArray()) {
                m.add(2.fromJsonElement(o));
            }
            return m;
        }

        @Override
        public JsonElement toPrimitive(Collection<Object> m) {
            JsonArray ja = new JsonArray();
            for (Object o : m) {
                ja.add(2.toJsonElement(o));
            }
            return ja;
        }
    };
    protected static DropElementSerializer<String> STRING = new DropElementSerializer<String>(new String[]{"string"}){

        @Override
        public JsonElement toPrimitive(String b) {
            return new JsonPrimitive(b);
        }

        @Override
        public String from(String type, JsonElement e) {
            return e.getAsString();
        }
    };
    protected static DropElementSerializer<Boolean> BOOLEAN = new DropElementSerializer<Boolean>(new String[]{"boolean"}){

        @Override
        public Boolean from(String type, JsonElement e) {
            return e.getAsBoolean();
        }

        @Override
        public JsonElement toPrimitive(Boolean b) {
            return new JsonPrimitive(b);
        }
    };
    protected static DropElementSerializer<Double> DOUBLE = new DropElementSerializer<Double>(new String[]{"float"}){

        @Override
        public Double from(String type, JsonElement e) {
            return e.getAsDouble();
        }

        @Override
        public JsonElement toPrimitive(Double d) {
            return new JsonPrimitive((Number)d);
        }
    };
    protected static DropElementSerializer<Integer> INTEGER = new DropElementSerializer<Integer>(new String[]{"integer"}){

        @Override
        public Integer from(String type, JsonElement e) {
            return e.getAsInt();
        }

        @Override
        public JsonElement toPrimitive(Integer b) {
            return new JsonPrimitive((Number)b);
        }
    };
    protected static DropElementSerializer<Long> LONG = new DropElementSerializer<Long>(new String[]{"long"}){

        @Override
        public Long from(String type, JsonElement e) {
            return e.getAsLong();
        }

        @Override
        public JsonElement toPrimitive(Long b) {
            return new JsonPrimitive((Number)b);
        }
    };
    protected static DropElementSerializer<Date> DATE = new DropElementSerializer<Date>(new String[]{"date"}){

        @Override
        public Date from(String type, JsonElement e) {
            return new Date(e.getAsLong());
        }

        @Override
        public JsonElement toPrimitive(Date d) {
            return new JsonPrimitive((Number)d.getTime());
        }
    };
    protected static DropElementSerializer<Location> LOCATION = new DropElementSerializer<Location>(new String[]{"location"}){

        @Override
        public Location from(String type, JsonElement elem) {
            JsonObject jo = (JsonObject)elem;
            Location loc = new Location();
            loc.setLatitude(jo.get("lat").getAsDouble());
            loc.setLongitude(jo.get("lon").getAsDouble());
            if (jo.has("specifiers")) {
                loc.setSpecifiers((HashMap)MAP.from("map", (JsonElement)jo.getAsJsonObject("specifiers")));
            }
            return loc;
        }

        public JsonObject toPrimitive(Location m) {
            JsonObject o = new JsonObject();
            JsonObject specMap = new JsonObject();
            for (String s : m.getSpecifiers().keySet()) {
                Object spec = m.getSpecifiers().get(s);
                specMap.add(s, 9.toJsonElement(spec));
            }
            o.add("specifiers", (JsonElement)specMap);
            o.addProperty("lat", (Number)m.getLatitude());
            o.addProperty("lon", (Number)m.getLongitude());
            return o;
        }
    };
    static final HashMap<Object, DropElementSerializer<?>> serializerMap = new HashMap();

    public DropElementSerializer(String ... typeKeys) {
        this.typeKeys = typeKeys;
    }

    public abstract T from(String var1, JsonElement var2);

    protected String getTypeKey(T o) {
        return this.typeKeys[0];
    }

    public JsonElement to(T o) {
        return this.toPrimitive(o);
    }

    public abstract JsonElement toPrimitive(T var1);

    public static Object fromJsonElement(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (e instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)e;
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                Number number = p.getAsNumber();
                if (number.doubleValue() % 1.0 == 0.0) {
                    return number.longValue();
                }
                return number.doubleValue();
            }
            return p.getAsString();
        }
        if (e instanceof JsonArray) {
            return COLLECTION.from("list", e);
        }
        if (e instanceof JsonObject) {
            return MAP.from("map", e);
        }
        return e;
    }

    public static JsonElement toJsonElement(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        DropElementSerializer<?> s = serializerMap.get(type);
        if (s == null) {
            if (o instanceof Map) {
                return MAP.to((Map)o);
            }
            if (o instanceof Collection) {
                return COLLECTION.to((Collection)o);
            }
        }
        if (s == null) {
            throw new UnsupportedOperationException("Don't know how to create json from Object " + o + " of type " + o.getClass());
        }
        return s.to(o);
    }

    protected static int extractIntMember(JsonObject o, String key) {
        return o.has(key) ? o.getAsJsonPrimitive(key).getAsInt() : 0;
    }

    static {
        for (Field f : DropElementSerializer.class.getDeclaredFields()) {
            if (!DropElementSerializer.class.isAssignableFrom(f.getType())) continue;
            try {
                DropElementSerializer s = (DropElementSerializer)f.get(null);
                for (String key : s.typeKeys) {
                    serializerMap.put(key, s);
                }
                Type serializerType = ((ParameterizedType)s.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                if (serializerType instanceof Class) {
                    serializerMap.put(serializerType, s);
                    continue;
                }
                if (!(serializerType instanceof ParameterizedType)) continue;
                serializerMap.put(((ParameterizedType)serializerType).getRawType(), s);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

