/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.services.tests.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.bson.Document;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoResource
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(MongoResource.class);
    private final Supplier<String> hostProvider;
    private final int port;
    private final LinkedList<MongoClient> clients = new LinkedList();
    private final HashSet<String> testDBs = new HashSet();
    private final HashSet<DbCollection> testCollections = new HashSet();
    private final HashSet<CollectionImport> collectionImports = new HashSet();

    public MongoResource(Supplier<String> host, int port) {
        this.hostProvider = host;
        this.port = port;
    }

    public String host() {
        return this.hostProvider.get();
    }

    public int port() {
        return this.port;
    }

    public MongoClient newClient() {
        MongoClientURI mongoClientURI = new MongoClientURI(String.format("mongodb://%s:%s", this.hostProvider.get(), this.port));
        MongoClient mongoClient = new MongoClient(mongoClientURI);
        this.clients.add(mongoClient);
        return mongoClient;
    }

    public MongoResource testDB(String dbname) {
        this.testDBs.add(dbname);
        return this;
    }

    public MongoResource testCollection(String dbname, String collectionName) {
        this.testCollections.add(new DbCollection(dbname, collectionName));
        return this;
    }

    protected void before() throws Throwable {
        try (MongoClient client = this.newClient();){
            for (CollectionImport anImport : this.collectionImports) {
                this.doImport(anImport, client);
            }
        }
    }

    private void doImport(CollectionImport anImport, MongoClient client) throws Exception {
        LinkedList<Document> docs = new LinkedList<Document>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(anImport.mongoExportResource)));){
            String line = reader.readLine();
            while (line != null) {
                if (line.trim().startsWith("{")) {
                    docs.add(Document.parse((String)line.trim()));
                }
                line = reader.readLine();
            }
        }
        log.debug("importing {}/{} contents from {}...", new Object[]{anImport.db, anImport.collection, anImport.mongoExportResource});
        client.getDatabase(anImport.db).getCollection(anImport.collection).insertMany(docs);
        log.debug("done importing {} documents.", (Object)docs.size());
    }

    protected void after() {
        MongoClient c = this.newClient();
        for (DbCollection dbCollection : this.testCollections) {
            if (!MongoResource.contains(c.listDatabaseNames(), dbCollection.db) || !MongoResource.contains(c.getDatabase(dbCollection.db).listCollectionNames(), dbCollection.collection)) continue;
            c.getDatabase(dbCollection.db).getCollection(dbCollection.collection).drop();
            log.debug("dropped collection {}", (Object)dbCollection);
        }
        for (String db : this.testDBs) {
            if (!MongoResource.contains(c.listDatabaseNames(), db)) continue;
            c.getDatabase(db).drop();
            log.debug("dropped db {}", (Object)db);
        }
        for (MongoClient client : this.clients) {
            client.close();
        }
    }

    private static <T> boolean contains(Iterable<T> iterable, T elmt) {
        for (T v : iterable) {
            if (!v.equals(elmt)) continue;
            return true;
        }
        return false;
    }

    public MongoResource importCollectionContent(String exportResource, String db, String collection) {
        this.collectionImports.add(new CollectionImport(db, collection, exportResource));
        return this;
    }

    class CollectionImport {
        public final String db;
        public final String collection;
        public final String mongoExportResource;

        public CollectionImport(String db, String collection, String mongoExportResource) {
            this.db = db;
            this.collection = collection;
            this.mongoExportResource = mongoExportResource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionImport that = (CollectionImport)o;
            if (this.db != null ? !this.db.equals(that.db) : that.db != null) {
                return false;
            }
            if (this.collection != null ? !this.collection.equals(that.collection) : that.collection != null) {
                return false;
            }
            return this.mongoExportResource != null ? this.mongoExportResource.equals(that.mongoExportResource) : that.mongoExportResource == null;
        }

        public int hashCode() {
            int result = this.db != null ? this.db.hashCode() : 0;
            result = 31 * result + (this.collection != null ? this.collection.hashCode() : 0);
            result = 31 * result + (this.mongoExportResource != null ? this.mongoExportResource.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CollectionImport{db='" + this.db + '\'' + ", collection='" + this.collection + '\'' + ", mongoExportResource='" + this.mongoExportResource + '\'' + '}';
        }
    }

    class DbCollection {
        public final String db;
        public final String collection;

        public DbCollection(String db, String collection) {
            this.db = db;
            this.collection = collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DbCollection that = (DbCollection)o;
            if (this.db != null ? !this.db.equals(that.db) : that.db != null) {
                return false;
            }
            return this.collection != null ? this.collection.equals(that.collection) : that.collection == null;
        }

        public int hashCode() {
            int result = this.db != null ? this.db.hashCode() : 0;
            result = 31 * result + (this.collection != null ? this.collection.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DbCollection{db='" + this.db + '\'' + ", collection='" + this.collection + '\'' + '}';
        }
    }
}

