/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.commons.graylog.client;

import io.flexio.commons.graylog.api.AbsoluteGetRequest;
import io.flexio.commons.graylog.api.AbsoluteGetResponse;
import io.flexio.commons.graylog.api.GraylogAPIHandlers;
import io.flexio.commons.graylog.api.RelativeGetRequest;
import io.flexio.commons.graylog.api.RelativeGetResponse;
import io.flexio.commons.graylog.client.GraylogAPIClient;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class GraylogAPIHandlersClient
implements GraylogAPIClient {
    private final GraylogAPIHandlers handlers;
    private final ExecutorService executor;

    public GraylogAPIHandlersClient(GraylogAPIHandlers handlers, ExecutorService executor) {
        this.handlers = handlers;
        this.executor = executor;
    }

    private <T> T call(Callable<T> callable, String action) throws IOException {
        try {
            return this.executor.submit(callable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("error invoking " + action, e);
        }
    }

    @Override
    public GraylogAPIClient.Api api() {
        return new ApiImpl();
    }

    private class ApiImpl
    implements GraylogAPIClient.Api {
        private ApiImpl() {
        }

        @Override
        public GraylogAPIClient.Api.Search search() {
            return new SearchImpl();
        }

        private class SearchImpl
        implements GraylogAPIClient.Api.Search {
            private SearchImpl() {
            }

            @Override
            public GraylogAPIClient.Api.Search.Universal universal() {
                return new UniversalImpl();
            }

            private class UniversalImpl
            implements GraylogAPIClient.Api.Search.Universal {
                private UniversalImpl() {
                }

                @Override
                public GraylogAPIClient.Api.Search.Universal.Relative relative() {
                    return new RelativeImpl();
                }

                @Override
                public GraylogAPIClient.Api.Search.Universal.Absolute absolute() {
                    return new AbsoluteImpl();
                }

                private class AbsoluteImpl
                implements GraylogAPIClient.Api.Search.Universal.Absolute {
                    private AbsoluteImpl() {
                    }

                    @Override
                    public AbsoluteGetResponse get(AbsoluteGetRequest request) throws IOException {
                        return (AbsoluteGetResponse)GraylogAPIHandlersClient.this.call(() -> GraylogAPIHandlersClient.this.handlers.absoluteGetHandler().apply(request), "Absolute get");
                    }

                    @Override
                    public AbsoluteGetResponse get(Consumer<AbsoluteGetRequest.Builder> request) throws IOException {
                        return (AbsoluteGetResponse)GraylogAPIHandlersClient.this.call(() -> {
                            AbsoluteGetRequest.Builder builder = AbsoluteGetRequest.builder();
                            request.accept(builder);
                            return GraylogAPIHandlersClient.this.handlers.absoluteGetHandler().apply(builder.build());
                        }, "Absolute get");
                    }
                }

                private class RelativeImpl
                implements GraylogAPIClient.Api.Search.Universal.Relative {
                    private RelativeImpl() {
                    }

                    @Override
                    public RelativeGetResponse get(RelativeGetRequest request) throws IOException {
                        return (RelativeGetResponse)GraylogAPIHandlersClient.this.call(() -> GraylogAPIHandlersClient.this.handlers.relativeGetHandler().apply(request), "Relative get");
                    }

                    @Override
                    public RelativeGetResponse get(Consumer<RelativeGetRequest.Builder> request) throws IOException {
                        return (RelativeGetResponse)GraylogAPIHandlersClient.this.call(() -> {
                            RelativeGetRequest.Builder builder = RelativeGetRequest.builder();
                            request.accept(builder);
                            return GraylogAPIHandlersClient.this.handlers.relativeGetHandler().apply(builder.build());
                        }, "Relative get");
                    }
                }
            }
        }
    }
}

