/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.commons.graylog.api;

import io.flexio.commons.graylog.api.RelativeGetRequestImpl;
import io.flexio.commons.graylog.api.ValueList;
import io.flexio.commons.graylog.api.optional.OptionalRelativeGetRequest;
import java.util.Collection;

public interface RelativeGetRequest {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(RelativeGetRequest value) {
        if (value != null) {
            return new Builder().query(value.query()).range(value.range()).limit(value.limit()).offset(value.offset()).filter(value.filter()).fields(value.fields()).sort(value.sort()).decorate(value.decorate()).accept(value.accept()).authorization(value.authorization());
        }
        return null;
    }

    public String query();

    public String range();

    public Long limit();

    public Long offset();

    public String filter();

    public ValueList<String> fields();

    public String sort();

    public Boolean decorate();

    public String accept();

    public String authorization();

    public RelativeGetRequest withQuery(String var1);

    public RelativeGetRequest withRange(String var1);

    public RelativeGetRequest withLimit(Long var1);

    public RelativeGetRequest withOffset(Long var1);

    public RelativeGetRequest withFilter(String var1);

    public RelativeGetRequest withFields(ValueList<String> var1);

    public RelativeGetRequest withSort(String var1);

    public RelativeGetRequest withDecorate(Boolean var1);

    public RelativeGetRequest withAccept(String var1);

    public RelativeGetRequest withAuthorization(String var1);

    public int hashCode();

    public RelativeGetRequest changed(Changer var1);

    public OptionalRelativeGetRequest opt();

    public static interface Changer {
        public Builder configure(Builder var1);
    }

    public static class Builder {
        private String query;
        private String range;
        private Long limit;
        private Long offset;
        private String filter;
        private ValueList<String> fields;
        private String sort;
        private Boolean decorate;
        private String accept;
        private String authorization;

        public RelativeGetRequest build() {
            return new RelativeGetRequestImpl(this.query, this.range, this.limit, this.offset, this.filter, this.fields, this.sort, this.decorate, this.accept, this.authorization);
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder range(String range) {
            this.range = range;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder offset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder fields() {
            this.fields = null;
            return this;
        }

        public Builder fields(String ... fields) {
            this.fields = fields != null ? new ValueList.Builder<String>().with(fields).build() : null;
            return this;
        }

        public Builder fields(ValueList<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Collection<String> fields) {
            this.fields = fields != null ? new ValueList.Builder<String>().with(fields).build() : null;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder decorate(Boolean decorate) {
            this.decorate = decorate;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }
    }
}

