/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.commons.graylog.api.absolutegetresponse.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.flexio.commons.graylog.api.absolutegetresponse.Status200;
import io.flexio.commons.graylog.api.types.json.SearchResponseReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Status200Reader {
    public Status200 read(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() != JsonToken.START_OBJECT) {
            throw new IOException(String.format("reading a %s object, was expecting %s, but was %s", Status200.class.getName(), JsonToken.START_OBJECT, parser.currentToken()));
        }
        Status200.Builder builder = Status200.builder();
        block3: while (parser.nextToken() != JsonToken.END_OBJECT) {
            Token token = Token.from(parser.getCurrentName());
            if (token != null) {
                switch (token) {
                    case PAYLOAD: {
                        parser.nextToken();
                        builder.payload(new SearchResponseReader().read(parser));
                        continue block3;
                    }
                }
                this.consumeUnexpectedProperty(parser);
                continue;
            }
            this.consumeUnexpectedProperty(parser);
        }
        return builder.build();
    }

    public Status200[] readArray(JsonParser parser) throws IOException {
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == JsonToken.START_ARRAY) {
            LinkedList<Status200> listValue = new LinkedList<Status200>();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                if (parser.currentToken() == JsonToken.VALUE_NULL) {
                    listValue.add(null);
                    continue;
                }
                listValue.add(this.read(parser));
            }
            return listValue.toArray(new Status200[listValue.size()]);
        }
        throw new IOException(String.format("failed reading io.flexio.commons.graylog.api.absolutegetresponse.Status200 array, current token was %s", parser.currentToken()));
    }

    private <T> T readValue(JsonParser parser, Reader<T> reader, String propertyName, Set<JsonToken> expectedTokens) throws IOException {
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (expectedTokens.contains(parser.currentToken())) {
            return reader.read(parser);
        }
        throw new IOException(String.format("reading property %s, was expecting %s, but was %s", propertyName, expectedTokens, parser.currentToken()));
    }

    private <T> List<T> readListValue(JsonParser parser, Reader<T> reader, String propertyName) throws IOException {
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == JsonToken.START_ARRAY) {
            LinkedList<T> listValue = new LinkedList<T>();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                if (parser.currentToken() == JsonToken.VALUE_NULL) {
                    listValue.add(null);
                    continue;
                }
                listValue.add(reader.read(parser));
            }
            return listValue;
        }
        throw new IOException(String.format("reading property %s, was expecting %s, but was %s", propertyName, JsonToken.START_ARRAY, parser.currentToken()));
    }

    private void consumeUnexpectedProperty(JsonParser parser) throws IOException {
        parser.nextToken();
        if (parser.currentToken().isStructStart()) {
            int level = 1;
            do {
                parser.nextToken();
                if (parser.currentToken().isStructStart()) {
                    ++level;
                }
                if (!parser.currentToken().isStructEnd()) continue;
                --level;
            } while (level > 0);
        }
    }

    static enum Token {
        __UNKNOWN__("__UNKNOWN__", "__UNKNOWN__"),
        PAYLOAD("payload", "payload");

        private final String name;
        private final String rawName;

        private Token(String name, String rawName) {
            this.name = name;
            this.rawName = rawName;
        }

        private static String normalizeFieldName(String fieldName) {
            if (fieldName == null) {
                return null;
            }
            if (fieldName.trim().equals("")) {
                return "";
            }
            fieldName = Arrays.stream(fieldName.split("(\\s|-)+")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining());
            fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            return fieldName;
        }

        public static Token from(String str) {
            for (Token token : Token.values()) {
                if (token.name.equals(str)) {
                    return token;
                }
                if (token.rawName.equals(str)) {
                    return token;
                }
                if (token.name.equals(Token.normalizeFieldName(str))) {
                    return token;
                }
                if (!token.rawName.equals(Token.normalizeFieldName(str))) continue;
                return token;
            }
            return __UNKNOWN__;
        }
    }

    @FunctionalInterface
    private static interface Reader<T> {
        public T read(JsonParser var1) throws IOException;
    }
}

