/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.commons.graylog.api.types;

import io.flexio.commons.graylog.api.types.ValueListImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Stream;

public interface ValueList<E>
extends Iterable<E> {
    public boolean contains(Object var1);

    public boolean containsAll(Collection<?> var1);

    public E get(int var1);

    public int size();

    public int indexOf(Object var1);

    public boolean isEmpty();

    public <T> T[] toArray(T[] var1);

    public Object[] toArray();

    public Stream<E> stream();

    public static class Builder<E> {
        private final LinkedList<E> delegate = new LinkedList();

        public ValueList<E> build() {
            return new ValueListImpl<E>(this.delegate);
        }

        public Builder with(E ... elements) {
            if (elements != null) {
                this.delegate.addAll(Arrays.asList(elements));
            }
            return this;
        }

        public Builder with(Collection<E> elements) {
            if (elements != null) {
                this.delegate.addAll(elements);
            }
            return this;
        }
    }
}

