/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.commons.graylog.api.types;

import io.flexio.commons.graylog.api.types.SearchResponseImpl;
import io.flexio.commons.graylog.api.types.ValueList;
import io.flexio.commons.graylog.api.types.optional.OptionalSearchResponse;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.codingmatters.value.objects.values.ObjectValue;

public interface SearchResponse {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(SearchResponse value) {
        if (value != null) {
            return new Builder().from(value.from()).to(value.to()).messages(value.messages()).fields(value.fields()).time(value.time()).built_query(value.built_query()).decoration_stats(value.decoration_stats()).total_results(value.total_results()).used_indices(value.used_indices()).query(value.query());
        }
        return null;
    }

    public String from();

    public String to();

    public ValueList<ObjectValue> messages();

    public ValueList<String> fields();

    public Long time();

    public String built_query();

    public ObjectValue decoration_stats();

    public Long total_results();

    public ValueList<ObjectValue> used_indices();

    public String query();

    public SearchResponse withFrom(String var1);

    public SearchResponse withTo(String var1);

    public SearchResponse withMessages(ValueList<ObjectValue> var1);

    public SearchResponse withFields(ValueList<String> var1);

    public SearchResponse withTime(Long var1);

    public SearchResponse withBuilt_query(String var1);

    public SearchResponse withDecoration_stats(ObjectValue var1);

    public SearchResponse withTotal_results(Long var1);

    public SearchResponse withUsed_indices(ValueList<ObjectValue> var1);

    public SearchResponse withQuery(String var1);

    public int hashCode();

    public SearchResponse changed(Changer var1);

    public OptionalSearchResponse opt();

    public static interface Changer {
        public Builder configure(Builder var1);
    }

    public static class Builder {
        private String from;
        private String to;
        private ValueList<ObjectValue> messages;
        private ValueList<String> fields;
        private Long time;
        private String built_query;
        private ObjectValue decoration_stats;
        private Long total_results;
        private ValueList<ObjectValue> used_indices;
        private String query;

        public SearchResponse build() {
            return new SearchResponseImpl(this.from, this.to, this.messages, this.fields, this.time, this.built_query, this.decoration_stats, this.total_results, this.used_indices, this.query);
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder messages() {
            this.messages = null;
            return this;
        }

        public Builder messages(ObjectValue ... messages) {
            this.messages = messages != null ? new ValueList.Builder<ObjectValue>().with(messages).build() : null;
            return this;
        }

        public Builder messages(ValueList<ObjectValue> messages) {
            this.messages = messages;
            return this;
        }

        public Builder messages(Collection<ObjectValue> messages) {
            this.messages = messages != null ? new ValueList.Builder<ObjectValue>().with(messages).build() : null;
            return this;
        }

        public Builder messages(Consumer<ObjectValue.Builder> ... messagesElements) {
            if (messagesElements != null) {
                LinkedList<ObjectValue> elements = new LinkedList<ObjectValue>();
                for (Consumer<ObjectValue.Builder> messages : messagesElements) {
                    ObjectValue.Builder builder = ObjectValue.builder();
                    messages.accept(builder);
                    elements.add(builder.build());
                }
                this.messages(elements.toArray(new ObjectValue[elements.size()]));
            }
            return this;
        }

        public Builder fields() {
            this.fields = null;
            return this;
        }

        public Builder fields(String ... fields) {
            this.fields = fields != null ? new ValueList.Builder<String>().with(fields).build() : null;
            return this;
        }

        public Builder fields(ValueList<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Collection<String> fields) {
            this.fields = fields != null ? new ValueList.Builder<String>().with(fields).build() : null;
            return this;
        }

        public Builder time(Long time) {
            this.time = time;
            return this;
        }

        public Builder built_query(String built_query) {
            this.built_query = built_query;
            return this;
        }

        public Builder decoration_stats(ObjectValue decoration_stats) {
            this.decoration_stats = decoration_stats;
            return this;
        }

        public Builder decoration_stats(Consumer<ObjectValue.Builder> decoration_stats) {
            ObjectValue.Builder builder = ObjectValue.builder();
            decoration_stats.accept(builder);
            return this.decoration_stats(builder.build());
        }

        public Builder total_results(Long total_results) {
            this.total_results = total_results;
            return this;
        }

        public Builder used_indices() {
            this.used_indices = null;
            return this;
        }

        public Builder used_indices(ObjectValue ... used_indices) {
            this.used_indices = used_indices != null ? new ValueList.Builder<ObjectValue>().with(used_indices).build() : null;
            return this;
        }

        public Builder used_indices(ValueList<ObjectValue> used_indices) {
            this.used_indices = used_indices;
            return this;
        }

        public Builder used_indices(Collection<ObjectValue> used_indices) {
            this.used_indices = used_indices != null ? new ValueList.Builder<ObjectValue>().with(used_indices).build() : null;
            return this;
        }

        public Builder used_indices(Consumer<ObjectValue.Builder> ... used_indicesElements) {
            if (used_indicesElements != null) {
                LinkedList<ObjectValue> elements = new LinkedList<ObjectValue>();
                for (Consumer<ObjectValue.Builder> used_indices : used_indicesElements) {
                    ObjectValue.Builder builder = ObjectValue.builder();
                    used_indices.accept(builder);
                    elements.add(builder.build());
                }
                this.used_indices(elements.toArray(new ObjectValue[elements.size()]));
            }
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }
    }
}

