/*
 * Decompiled with CFR 0.152.
 */
package io.flexio.commons.graylog.api.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.flexio.commons.graylog.api.AbsoluteGetRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AbsoluteGetRequestReader {
    private static Set QUERY_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));
    private static Set FROM_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));
    private static Set TO_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));
    private static Set LIMIT_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_NUMBER_INT));
    private static Set OFFSET_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_NUMBER_INT));
    private static Set FILTER_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));
    private static Set SORT_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));
    private static Set DECORATE_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_TRUE, JsonToken.VALUE_FALSE));
    private static Set ACCEPT_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));
    private static Set AUTHORIZATION_EXPECTEDTOKENS = new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING));

    public AbsoluteGetRequest read(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() != JsonToken.START_OBJECT) {
            throw new IOException(String.format("reading a %s object, was expecting %s, but was %s", AbsoluteGetRequest.class.getName(), JsonToken.START_OBJECT, parser.currentToken()));
        }
        AbsoluteGetRequest.Builder builder = AbsoluteGetRequest.builder();
        block13: while (parser.nextToken() != JsonToken.END_OBJECT) {
            Token token = Token.from(parser.getCurrentName());
            if (token != null) {
                switch (token) {
                    case QUERY: {
                        Set expectedTokens = QUERY_EXPECTEDTOKENS;
                        builder.query(this.readValue(parser, jsonParser -> jsonParser.getText(), "query", expectedTokens));
                        continue block13;
                    }
                    case FROM: {
                        Set expectedTokens = FROM_EXPECTEDTOKENS;
                        builder.from(this.readValue(parser, jsonParser -> jsonParser.getText(), "from", expectedTokens));
                        continue block13;
                    }
                    case TO: {
                        Set expectedTokens = TO_EXPECTEDTOKENS;
                        builder.to(this.readValue(parser, jsonParser -> jsonParser.getText(), "to", expectedTokens));
                        continue block13;
                    }
                    case LIMIT: {
                        Set expectedTokens = LIMIT_EXPECTEDTOKENS;
                        builder.limit(this.readValue(parser, jsonParser -> jsonParser.getLongValue(), "limit", expectedTokens));
                        continue block13;
                    }
                    case OFFSET: {
                        Set expectedTokens = OFFSET_EXPECTEDTOKENS;
                        builder.offset(this.readValue(parser, jsonParser -> jsonParser.getLongValue(), "offset", expectedTokens));
                        continue block13;
                    }
                    case FILTER: {
                        Set expectedTokens = FILTER_EXPECTEDTOKENS;
                        builder.filter(this.readValue(parser, jsonParser -> jsonParser.getText(), "filter", expectedTokens));
                        continue block13;
                    }
                    case FIELDS: {
                        builder.fields(this.readListValue(parser, jsonParser -> jsonParser.getText(), "fields"));
                        continue block13;
                    }
                    case SORT: {
                        Set expectedTokens = SORT_EXPECTEDTOKENS;
                        builder.sort(this.readValue(parser, jsonParser -> jsonParser.getText(), "sort", expectedTokens));
                        continue block13;
                    }
                    case DECORATE: {
                        Set expectedTokens = DECORATE_EXPECTEDTOKENS;
                        builder.decorate(this.readValue(parser, jsonParser -> jsonParser.getBooleanValue(), "decorate", expectedTokens));
                        continue block13;
                    }
                    case ACCEPT: {
                        Set expectedTokens = ACCEPT_EXPECTEDTOKENS;
                        builder.accept(this.readValue(parser, jsonParser -> jsonParser.getText(), "accept", expectedTokens));
                        continue block13;
                    }
                    case AUTHORIZATION: {
                        Set expectedTokens = AUTHORIZATION_EXPECTEDTOKENS;
                        builder.authorization(this.readValue(parser, jsonParser -> jsonParser.getText(), "authorization", expectedTokens));
                        continue block13;
                    }
                }
                this.consumeUnexpectedProperty(parser);
                continue;
            }
            this.consumeUnexpectedProperty(parser);
        }
        return builder.build();
    }

    public AbsoluteGetRequest[] readArray(JsonParser parser) throws IOException {
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == JsonToken.START_ARRAY) {
            LinkedList<AbsoluteGetRequest> listValue = new LinkedList<AbsoluteGetRequest>();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                if (parser.currentToken() == JsonToken.VALUE_NULL) {
                    listValue.add(null);
                    continue;
                }
                listValue.add(this.read(parser));
            }
            return listValue.toArray(new AbsoluteGetRequest[listValue.size()]);
        }
        throw new IOException(String.format("failed reading io.flexio.commons.graylog.api.AbsoluteGetRequest array, current token was %s", parser.currentToken()));
    }

    private <T> T readValue(JsonParser parser, Reader<T> reader, String propertyName, Set<JsonToken> expectedTokens) throws IOException {
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (expectedTokens.contains(parser.currentToken())) {
            return reader.read(parser);
        }
        throw new IOException(String.format("reading property %s, was expecting %s, but was %s", propertyName, expectedTokens, parser.currentToken()));
    }

    private <T> List<T> readListValue(JsonParser parser, Reader<T> reader, String propertyName) throws IOException {
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == JsonToken.START_ARRAY) {
            LinkedList<T> listValue = new LinkedList<T>();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                if (parser.currentToken() == JsonToken.VALUE_NULL) {
                    listValue.add(null);
                    continue;
                }
                listValue.add(reader.read(parser));
            }
            return listValue;
        }
        throw new IOException(String.format("reading property %s, was expecting %s, but was %s", propertyName, JsonToken.START_ARRAY, parser.currentToken()));
    }

    private void consumeUnexpectedProperty(JsonParser parser) throws IOException {
        parser.nextToken();
        if (parser.currentToken().isStructStart()) {
            int level = 1;
            do {
                parser.nextToken();
                if (parser.currentToken().isStructStart()) {
                    ++level;
                }
                if (!parser.currentToken().isStructEnd()) continue;
                --level;
            } while (level > 0);
        }
    }

    static enum Token {
        __UNKNOWN__("__UNKNOWN__", "__UNKNOWN__"),
        QUERY("query", "query"),
        FROM("from", "from"),
        TO("to", "to"),
        LIMIT("limit", "limit"),
        OFFSET("offset", "offset"),
        FILTER("filter", "filter"),
        FIELDS("fields", "fields"),
        SORT("sort", "sort"),
        DECORATE("decorate", "decorate"),
        ACCEPT("accept", "accept"),
        AUTHORIZATION("authorization", "authorization");

        private final String name;
        private final String rawName;

        private Token(String name, String rawName) {
            this.name = name;
            this.rawName = rawName;
        }

        private static String normalizeFieldName(String fieldName) {
            if (fieldName == null) {
                return null;
            }
            if (fieldName.trim().equals("")) {
                return "";
            }
            fieldName = Arrays.stream(fieldName.split("(\\s|-)+")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining());
            fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            return fieldName;
        }

        public static Token from(String str) {
            for (Token token : Token.values()) {
                if (token.name.equals(str)) {
                    return token;
                }
                if (token.rawName.equals(str)) {
                    return token;
                }
                if (token.name.equals(Token.normalizeFieldName(str))) {
                    return token;
                }
                if (!token.rawName.equals(Token.normalizeFieldName(str))) continue;
                return token;
            }
            return __UNKNOWN__;
        }
    }

    @FunctionalInterface
    private static interface Reader<T> {
        public T read(JsonParser var1) throws IOException;
    }
}

