/*
 * Decompiled with CFR 0.152.
 */
package io.flatbufferx.processor.type.field;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.sun.tools.javac.code.Symbol;
import io.flatbufferx.processor.type.Type;
import io.flatbufferx.processor.type.field.BooleanFieldType;
import io.flatbufferx.processor.type.field.ByteFieldType;
import io.flatbufferx.processor.type.field.DoubleFieldType;
import io.flatbufferx.processor.type.field.DynamicFieldType;
import io.flatbufferx.processor.type.field.FloatFieldType;
import io.flatbufferx.processor.type.field.IntegerFieldType;
import io.flatbufferx.processor.type.field.LongFieldType;
import io.flatbufferx.processor.type.field.StringFieldType;
import io.flatbufferx.processor.type.field.TypeConverterFieldType;
import io.flatbufferx.processor.type.field.UnknownFieldType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class FieldType
extends Type {
    public static FieldType fieldTypeFor(TypeMirror typeMirror, TypeMirror typeConverterType, Elements elements, Types types) {
        if (typeMirror != null) {
            if (typeConverterType != null && !"void".equals(typeConverterType.toString())) {
                return new TypeConverterFieldType(TypeName.get((TypeMirror)typeMirror), ClassName.bestGuess((String)typeConverterType.toString()));
            }
            if (typeMirror.getKind() == TypeKind.BOOLEAN) {
                return new BooleanFieldType(true);
            }
            if (Boolean.class.getCanonicalName().equals(typeMirror.toString())) {
                return new BooleanFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.BYTE) {
                return new ByteFieldType(true);
            }
            if (Byte.class.getCanonicalName().equals(typeMirror.toString())) {
                return new ByteFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.INT) {
                return new IntegerFieldType(true);
            }
            if (Integer.class.getCanonicalName().equals(typeMirror.toString())) {
                return new IntegerFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.LONG) {
                return new LongFieldType(true);
            }
            if (Long.class.getCanonicalName().equals(typeMirror.toString())) {
                return new LongFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.FLOAT) {
                return new FloatFieldType(true);
            }
            if (Float.class.getCanonicalName().equals(typeMirror.toString())) {
                return new FloatFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.DOUBLE) {
                return new DoubleFieldType(true);
            }
            if (Double.class.getCanonicalName().equals(typeMirror.toString())) {
                return new DoubleFieldType(false);
            }
            if (String.class.getCanonicalName().equals(typeMirror.toString())) {
                return new StringFieldType();
            }
            if (Object.class.getCanonicalName().equals(typeMirror.toString())) {
                return new UnknownFieldType();
            }
            return new DynamicFieldType(TypeName.get((TypeMirror)typeMirror));
        }
        return null;
    }

    public static FieldType fieldTypeForMethod(Elements elements, Types types, Symbol.MethodSymbol enclosedElement) {
        String type = enclosedElement.getReturnType().toString();
        if (Boolean.class.getCanonicalName().equals(type) || Boolean.TYPE.getCanonicalName().equals(type)) {
            return new BooleanFieldType(false);
        }
        if (Byte.class.getCanonicalName().equals(type)) {
            return new ByteFieldType(false);
        }
        if (Integer.class.getCanonicalName().equals(type) || Integer.TYPE.getCanonicalName().equals(type)) {
            return new IntegerFieldType(false);
        }
        if (Long.class.getCanonicalName().equals(type) || Long.TYPE.getCanonicalName().equals(type)) {
            return new LongFieldType(false);
        }
        if (Float.class.getCanonicalName().equals(type)) {
            return new FloatFieldType(false);
        }
        if (Double.class.getCanonicalName().equals(type)) {
            return new DoubleFieldType(false);
        }
        if (String.class.getCanonicalName().equals(type)) {
            return new StringFieldType();
        }
        if (Object.class.getCanonicalName().equals(type)) {
            return new UnknownFieldType();
        }
        return new DynamicFieldType(TypeName.get((TypeMirror)enclosedElement.getReturnType()));
    }

    public static FieldType fieldTypeFor(String typeMirror) {
        if (typeMirror != null) {
            if (typeMirror.equals(Boolean.class.getCanonicalName())) {
                return new BooleanFieldType(true);
            }
            if (Boolean.class.getCanonicalName().equals(typeMirror)) {
                return new BooleanFieldType(false);
            }
            if (typeMirror.contentEquals(Byte.TYPE.getCanonicalName())) {
                return new ByteFieldType(true);
            }
            if (typeMirror.contentEquals(Byte.class.getCanonicalName())) {
                return new ByteFieldType(false);
            }
            if (typeMirror.contentEquals(Integer.TYPE.getCanonicalName())) {
                return new IntegerFieldType(true);
            }
            if (Integer.class.getCanonicalName().equals(typeMirror)) {
                return new IntegerFieldType(false);
            }
            if (typeMirror.contentEquals(Long.TYPE.getCanonicalName())) {
                return new LongFieldType(true);
            }
            if (typeMirror.contentEquals(Long.class.getCanonicalName())) {
                return new LongFieldType(false);
            }
            if (typeMirror.contentEquals(Float.TYPE.getCanonicalName())) {
                return new FloatFieldType(true);
            }
            if (typeMirror.contentEquals(Float.class.getCanonicalName())) {
                return new FloatFieldType(false);
            }
            if (typeMirror.contentEquals(Double.TYPE.getCanonicalName())) {
                return new DoubleFieldType(true);
            }
            if (typeMirror.contentEquals(Double.class.getCanonicalName())) {
                return new DoubleFieldType(false);
            }
            if (String.class.getCanonicalName().equals(typeMirror)) {
                return new StringFieldType();
            }
            if (Object.class.getCanonicalName().equals(typeMirror)) {
                return new UnknownFieldType();
            }
            return new DynamicFieldType((TypeName)ClassName.bestGuess((String)typeMirror));
        }
        return null;
    }

    protected static String replaceLastLiteral(String string, String replacement) {
        int pos = string.lastIndexOf("$L");
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + 2, string.length());
        }
        return string;
    }

    public abstract TypeName getNonPrimitiveTypeName();

    @Override
    public String getParameterizedTypeString() {
        return "$T";
    }

    @Override
    public Object[] getParameterizedTypeStringArgs() {
        return new Object[]{this.getNonPrimitiveTypeName()};
    }
}

