/*
 * Decompiled with CFR 0.152.
 */
package io.flatbufferx.processor.type.field;

import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import io.flatbufferx.processor.type.field.NumberFieldType;

public class DoubleFieldType
extends NumberFieldType {
    public DoubleFieldType(boolean isPrimitive) {
        super(isPrimitive);
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.DOUBLE : ClassName.get(Double.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Double.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = DoubleFieldType.replaceLastLiteral(setter, "$L.getValueAsDouble()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = DoubleFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : Double.valueOf($L.getValueAsDouble())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }
}

