/*
 * Decompiled with CFR 0.152.
 */
package io.flatbufferx.processor.type.collection;

import com.squareup.javapoet.ClassName;
import io.flatbufferx.processor.processor.TypeUtils;
import io.flatbufferx.processor.type.Type;
import io.flatbufferx.processor.type.collection.ArrayListCollectionType;
import io.flatbufferx.processor.type.collection.HashMapCollectionType;
import io.flatbufferx.processor.type.collection.LinkedHashMapCollectionType;
import io.flatbufferx.processor.type.collection.LinkedListCollectionType;
import io.flatbufferx.processor.type.collection.QueueCollectionType;
import io.flatbufferx.processor.type.collection.SetCollectionType;
import io.flatbufferx.processor.type.collection.TreeMapCollectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class CollectionType
extends Type {
    public static CollectionType collectionTypeFor(TypeMirror typeMirror, TypeMirror genericClassTypeMirror, Elements elements, Types types) {
        String typeMirrorInfo;
        CollectionType collectionType = null;
        switch (typeMirrorInfo = genericClassTypeMirror.toString().replaceAll("<.*>", "")) {
            case "java.util.List": 
            case "java.util.ArrayList": {
                collectionType = new ArrayListCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
                break;
            }
            case "java.util.LinkedList": {
                collectionType = new LinkedListCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
                break;
            }
            case "java.util.Map": 
            case "java.util.HashMap": {
                collectionType = new HashMapCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
                break;
            }
            case "java.util.TreeMap": {
                collectionType = new TreeMapCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
                break;
            }
            case "java.util.LinkedHashMap": {
                collectionType = new LinkedHashMapCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
                break;
            }
            case "java.util.Set": 
            case "java.util.HashSet": {
                collectionType = new SetCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
                break;
            }
            case "java.util.Queue": 
            case "java.util.Deque": 
            case "java.util.ArrayDeque": {
                collectionType = new QueueCollectionType(ClassName.bestGuess((String)typeMirrorInfo));
            }
        }
        if (collectionType != null) {
            collectionType.addParameterTypes(TypeUtils.getParameterizedTypes(typeMirror), elements, types);
        }
        return collectionType;
    }
}

