/*
 * Decompiled with CFR 0.152.
 */
package io.flatbufferx.processor.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import io.flatbufferx.core.FlatBufferMapper;
import io.flatbufferx.core.JsonMapperLoader;
import io.flatbufferx.core.ParameterizedType;
import io.flatbufferx.core.objectmappers.BooleanMapper;
import io.flatbufferx.core.objectmappers.DoubleMapper;
import io.flatbufferx.core.objectmappers.FloatMapper;
import io.flatbufferx.core.objectmappers.IntegerMapper;
import io.flatbufferx.core.objectmappers.ListMapper;
import io.flatbufferx.core.objectmappers.LongMapper;
import io.flatbufferx.core.objectmappers.MapMapper;
import io.flatbufferx.core.objectmappers.ObjectMapper;
import io.flatbufferx.core.objectmappers.StringMapper;
import io.flatbufferx.core.util.SimpleArrayMap;
import io.flatbufferx.processor.processor.JsonObjectHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public class FlatBuffersInjector {
    private final Collection<JsonObjectHolder> mJsonObjectHolders;

    public FlatBuffersInjector(Collection<JsonObjectHolder> jsonObjectHolders) {
        this.mJsonObjectHolders = jsonObjectHolders;
    }

    public static String getMapperVariableName(Class cls) {
        return FlatBuffersInjector.getMapperVariableName(cls.getCanonicalName());
    }

    public static String getMapperVariableName(String fullyQualifiedClassName) {
        return fullyQualifiedClassName.replaceAll("\\.", "_").replaceAll("\\$", "_").toUpperCase();
    }

    public String getJavaClassFile() {
        try {
            return JavaFile.builder((String)"io.flatbufferx", (TypeSpec)this.getTypeSpec()).build().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TypeSpec getTypeSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"FlatBuffersXLoader").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        builder.addSuperinterface((TypeName)ClassName.get(JsonMapperLoader.class));
        builder.addMethod(this.getPutAllJsonMappersMethodEmpty(builder));
        this.addParameterizedMapperGetters(builder);
        this.addDefaultSize(builder);
        builder.addMethod(this.getPutAllJsoClassMappersMethod(builder));
        return builder.build();
    }

    private void addAllBuiltInMappers(TypeSpec.Builder typeSpecBuilder) {
        this.addBuiltInMapper(typeSpecBuilder, StringMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, IntegerMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, LongMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, FloatMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, DoubleMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, BooleanMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, ObjectMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, ListMapper.class);
        this.addBuiltInMapper(typeSpecBuilder, MapMapper.class);
    }

    private void addBuiltInMapper(TypeSpec.Builder typeSpecBuilder, Class mapperClass) {
        typeSpecBuilder.addField(FieldSpec.builder((Type)mapperClass, (String)FlatBuffersInjector.getMapperVariableName(mapperClass), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{mapperClass}).build());
    }

    private void addDefaultSize(TypeSpec.Builder typeSpecBuilder) {
        typeSpecBuilder.addField(FieldSpec.builder(Integer.TYPE, (String)"DEFAULT_MAP_SIZE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(this.mJsonObjectHolders.size() + "", new Object[0]).build());
    }

    private MethodSpec getPutAllJsonMappersMethodEmpty(TypeSpec.Builder typeSpecBuilder) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"putAllJsonMappers").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimpleArrayMap.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(FlatBufferMapper.class)}), "map", new Modifier[0]);
        return builder.build();
    }

    private MethodSpec getPutAllJsonMappersMethod(TypeSpec.Builder typeSpecBuilder) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"putAllJsonMappers").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimpleArrayMap.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(FlatBufferMapper.class)}), "map", new Modifier[0]).addStatement("map.put($T.class, $L)", new Object[]{String.class, FlatBuffersInjector.getMapperVariableName(StringMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{Integer.class, FlatBuffersInjector.getMapperVariableName(IntegerMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{Long.class, FlatBuffersInjector.getMapperVariableName(LongMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{Float.class, FlatBuffersInjector.getMapperVariableName(FloatMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{Double.class, FlatBuffersInjector.getMapperVariableName(DoubleMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{Boolean.class, FlatBuffersInjector.getMapperVariableName(BooleanMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{Object.class, FlatBuffersInjector.getMapperVariableName(ObjectMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{List.class, FlatBuffersInjector.getMapperVariableName(ListMapper.class)}).addStatement("map.put($T.class, $L)", new Object[]{ArrayList.class, FlatBuffersInjector.getMapperVariableName(ListMapper.class)});
        ArrayList<String> createdMappers = new ArrayList<String>();
        for (JsonObjectHolder jsonObjectHolder : this.mJsonObjectHolders) {
            if (jsonObjectHolder.typeParameters.size() != 0) continue;
            ClassName mapperTypeName = ClassName.get((String)jsonObjectHolder.packageName, (String)jsonObjectHolder.injectedClassName, (String[])new String[0]);
            String variableName = FlatBuffersInjector.getMapperVariableName(jsonObjectHolder.packageName + "." + jsonObjectHolder.injectedClassName);
            typeSpecBuilder.addField(FieldSpec.builder((TypeName)mapperTypeName, (String)variableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build());
            createdMappers.add(variableName);
            builder.addStatement("$L = new $T()", new Object[]{variableName, mapperTypeName});
            if (jsonObjectHolder.isAbstractClass) continue;
            builder.addStatement("map.put($T.class, $L)", new Object[]{jsonObjectHolder.objectTypeName, variableName});
        }
        return builder.build();
    }

    private MethodSpec getPutAllJsoClassMappersMethod(TypeSpec.Builder typeSpecBuilder) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"retainAllClassMapper").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimpleArrayMap.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(Class.class)}), "map", new Modifier[0]);
        for (JsonObjectHolder jsonObjectHolder : this.mJsonObjectHolders) {
            if (jsonObjectHolder.typeParameters.size() != 0) continue;
            ClassName mapperTypeName = ClassName.get((String)jsonObjectHolder.packageName, (String)jsonObjectHolder.injectedClassName, (String[])new String[0]);
            if (jsonObjectHolder.isAbstractClass) continue;
            builder.addStatement("map.put($T.class, $T.class)", new Object[]{jsonObjectHolder.objectTypeName, mapperTypeName});
        }
        return builder.build();
    }

    private void addParameterizedMapperGetters(TypeSpec.Builder builder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"mapperFor").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(FlatBufferMapper.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ParameterizedType.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "type", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimpleArrayMap.class), (TypeName[])new TypeName[]{ClassName.get(ParameterizedType.class), ClassName.get(FlatBufferMapper.class)}), "partialMappers", new Modifier[0]);
        boolean conditionalStarted = false;
        for (JsonObjectHolder jsonObjectHolder : this.mJsonObjectHolders) {
            if (jsonObjectHolder.typeParameters.size() <= 0) continue;
            String conditional = String.format("if (type.rawType == %s.class)", jsonObjectHolder.objectTypeName.toString().replaceAll("<(.*?)>", ""));
            if (conditionalStarted) {
                methodBuilder.nextControlFlow("else " + conditional, new Object[0]);
            } else {
                conditionalStarted = true;
                methodBuilder.beginControlFlow(conditional, new Object[0]);
            }
            methodBuilder.beginControlFlow("if (type.typeParameters.size() == $L)", new Object[]{jsonObjectHolder.typeParameters.size()});
            StringBuilder constructorArgs = new StringBuilder();
            for (int i = 0; i < jsonObjectHolder.typeParameters.size(); ++i) {
                constructorArgs.append(", type.typeParameters.get(").append(i).append(")");
            }
            methodBuilder.addStatement("return new $T(type" + constructorArgs.toString() + ", partialMappers)", new Object[]{ClassName.get((String)jsonObjectHolder.packageName, (String)jsonObjectHolder.injectedClassName, (String[])new String[0])});
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("throw new $T(\"Invalid number of parameter types. Type $T expects $L parameter types, received \" + type.typeParameters.size())", new Object[]{RuntimeException.class, jsonObjectHolder.objectTypeName, jsonObjectHolder.typeParameters.size()});
            methodBuilder.endControlFlow();
        }
        if (conditionalStarted) {
            methodBuilder.endControlFlow();
        }
        methodBuilder.addStatement("return null", new Object[0]);
        builder.addMethod(methodBuilder.build());
    }
}

