/*
 * Decompiled with CFR 0.152.
 */
package io.flatbufferx.processor;

import io.flatbufferx.core.annotation.JsonField;
import io.flatbufferx.core.annotation.JsonIgnore;
import io.flatbufferx.core.typeconverters.TypeConverter;
import io.flatbufferx.processor.Processor;
import io.flatbufferx.processor.processor.JsonFieldHolder;
import io.flatbufferx.processor.processor.JsonObjectHolder;
import io.flatbufferx.processor.processor.TextUtils;
import io.flatbufferx.processor.processor.TypeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class JsonFieldProcessor
extends Processor {
    public JsonFieldProcessor(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    @Override
    public Class getAnnotation() {
        return JsonField.class;
    }

    @Override
    public void findAndParseObjects(RoundEnvironment env, Map<String, JsonObjectHolder> jsonObjectMap, Elements elements, Types types) {
        for (Element element : env.getElementsAnnotatedWith(JsonField.class)) {
            try {
                this.processJsonFieldAnnotation(element, jsonObjectMap, elements, types);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate injector for %s. Stack trace incoming:\n%s", JsonField.class, stackTrace.toString());
            }
        }
    }

    private void processJsonFieldAnnotation(Element element, Map<String, JsonObjectHolder> jsonObjectMap, Elements elements, Types types) {
        TypeMirror typeConverterType;
        if (!this.isJsonFieldFieldAnnotationValid(element, elements)) {
            return;
        }
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        JsonObjectHolder objectHolder = jsonObjectMap.get(TypeUtils.getInjectedFQCN(enclosingElement, elements));
        JsonFieldHolder fieldHolder = objectHolder.fieldMap.get(element.getSimpleName().toString());
        if (fieldHolder == null) {
            fieldHolder = new JsonFieldHolder();
            objectHolder.fieldMap.put(element.getSimpleName().toString(), fieldHolder);
        }
        JsonField annotation = element.getAnnotation(JsonField.class);
        try {
            typeConverterType = this.mProcessingEnv.getElementUtils().getTypeElement(annotation.typeConverter().getCanonicalName()).asType();
        }
        catch (MirroredTypeException mte) {
            typeConverterType = mte.getTypeMirror();
        }
        String[] fieldName = annotation.name();
        JsonIgnore ignoreAnnotation = element.getAnnotation(JsonIgnore.class);
        boolean shouldParse = ignoreAnnotation == null || ignoreAnnotation.ignorePolicy() == JsonIgnore.IgnorePolicy.SERIALIZE_ONLY;
        boolean shouldSerialize = ignoreAnnotation == null || ignoreAnnotation.ignorePolicy() == JsonIgnore.IgnorePolicy.PARSE_ONLY;
        String error = fieldHolder.fill(element, elements, types, fieldName, typeConverterType, objectHolder, shouldParse, shouldSerialize);
        if (!TextUtils.isEmpty(error)) {
            this.error(element, error, new Object[0]);
        }
        this.ensureTypeConverterClassValid(typeConverterType, elements, types);
    }

    private boolean isJsonFieldFieldAnnotationValid(Element element, Elements elements) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (element.getModifiers().contains((Object)Modifier.PRIVATE) && (TextUtils.isEmpty(JsonFieldHolder.getGetter(element, elements)) || TextUtils.isEmpty(JsonFieldHolder.getSetter(element, elements)))) {
            this.error(element, "@%s annotation can only be used on private fields if both getter and setter are present.", JsonField.class.getSimpleName());
            return false;
        }
        return true;
    }

    private boolean ensureTypeConverterClassValid(TypeMirror typeConverterClassMirror, Elements elements, Types types) {
        TypeElement typeConverterElement = elements.getTypeElement(typeConverterClassMirror.toString());
        if (typeConverterElement != null) {
            boolean bl;
            boolean isTypeConverterType = false;
            TypeElement element = typeConverterElement;
            while (!isTypeConverterType && element != null) {
                for (TypeMirror typeMirror : element.getInterfaces()) {
                    if (!types.erasure(typeMirror).toString().equals(TypeConverter.class.getCanonicalName())) continue;
                    isTypeConverterType = true;
                }
                TypeMirror superClassMirror = element.getSuperclass();
                if (superClassMirror != null) {
                    superClassMirror = types.erasure(superClassMirror);
                    element = elements.getTypeElement(superClassMirror.toString());
                    continue;
                }
                element = null;
            }
            if (!isTypeConverterType) {
                this.error(element, "TypeConverter elements must implement the TypeConverter interface or extend from one of the convenience helpers (ie StringBasedTypeConverter or DateTypeConverter).", new Object[0]);
                return false;
            }
            boolean constructorIsDeclared = false;
            boolean bl2 = false;
            List<? extends Element> enclosedElements = typeConverterElement.getEnclosedElements();
            for (Element element2 : enclosedElements) {
                ExecutableElement executableElement;
                ElementKind enclosedElementKind = element2.getKind();
                if (enclosedElementKind != ElementKind.CONSTRUCTOR) continue;
                constructorIsDeclared = true;
                if (element2.getModifiers().contains((Object)Modifier.PRIVATE) || (executableElement = (ExecutableElement)element2).getParameters().size() != 0) continue;
                bl = true;
            }
            if (constructorIsDeclared && !bl) {
                this.error(element, "TypeConverter classes must have a non-private zero argument constructor.", new Object[0]);
                return false;
            }
        }
        return true;
    }
}

