/*
 * Decompiled with CFR 0.152.
 */
package io.firebus.discovery;

import io.firebus.Address;
import io.firebus.DiscoveryAgent;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.util.Config;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;

public class KubernetesDiscoveryAgent
extends DiscoveryAgent {
    private Logger logger;
    protected boolean active = false;
    protected CoreV1Api api;
    protected List<InetAddress> localAddresses;

    public void init() {
        this.logger = Logger.getLogger("io.firebus");
        this.setName("fbKubernetesDiscoveryAgent");
    }

    public void run() {
        V1PodList podList = null;
        V1Pod self = null;
        String namespace = null;
        try {
            this.localAddresses = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            while (ifs.hasMoreElements()) {
                NetworkInterface iface = ifs.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                for (InterfaceAddress ifaceAddress : iface.getInterfaceAddresses()) {
                    this.logger.fine("Added " + ifaceAddress.getAddress().getHostAddress() + " as a local address");
                    this.localAddresses.add(ifaceAddress.getAddress());
                }
            }
            ApiClient client = Config.defaultClient();
            client.setVerifyingSsl(false);
            Configuration.setDefaultApiClient((ApiClient)client);
            this.api = new CoreV1Api();
            podList = this.api.listPodForAllNamespaces(null, null, null, null, null, null, null, null, null);
            for (V1Pod pod : podList.getItems()) {
                String podIp = pod.getStatus().getPodIP();
                if (podIp == null) continue;
                for (InetAddress addr : this.localAddresses) {
                    if (addr == null || !podIp.equals(addr.getHostAddress())) continue;
                    self = pod;
                    namespace = pod.getMetadata().getNamespace();
                    String labelValue = this.nodeCore.getConnectionManager().getPort() + "." + this.nodeCore.getNetworkName() + "." + this.nodeCore.getNodeId();
                    String jsonPatchStr = "[{\"op\":\"add\",\"path\":\"/metadata/labels/io.firebus\",\"value\":\"" + labelValue + "\"}]";
                    this.api.patchNamespacedPod(pod.getMetadata().getName(), namespace, new V1Patch(jsonPatchStr), null, null, null, null);
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while trying to publish coordinates : " + e.getMessage());
        }
        this.active = true;
        try {
            while (this.active) {
                if (podList == null) continue;
                for (V1Pod pod : podList.getItems()) {
                    if (namespace != null && !pod.getMetadata().getNamespace().equals(namespace) || !pod.getMetadata().getLabels().containsKey("io.firebus") || pod.getStatus().getPodIP() == null || pod == self) continue;
                    String podIp = pod.getStatus().getPodIP();
                    String labelValue = (String)pod.getMetadata().getLabels().get("io.firebus");
                    String[] parts = labelValue.split("\\.");
                    int port = Integer.parseInt(parts[0]);
                    String network = parts.length >= 2 ? parts[1] : null;
                    String nodeId = parts.length >= 3 ? parts[2] : null;
                    Address address = new Address(podIp, port);
                    this.logger.fine("Found firebus node on " + pod.getMetadata().getName() + " : port " + port + " network " + network + (nodeId != null ? " nodeid " + nodeId : ""));
                    if (!this.nodeCore.getNetworkName().equals(network) && network != null) continue;
                    if (nodeId != null) {
                        this.nodeCore.getDirectory().processDiscoveredNode(port, address);
                        continue;
                    }
                    this.nodeCore.addKnownNodeAddress(podIp, port);
                }
                KubernetesDiscoveryAgent.sleep((long)300000L);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while looking for other nodes : " + e.getMessage());
        }
    }

    public void close() {
        this.active = false;
    }
}

