/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.core;

import io.featureflow.client.core.ConnectionHandler;
import io.featureflow.client.core.EventSourceHandler;
import io.featureflow.client.core.EventSourceParser;
import io.featureflow.client.core.FailedResponseException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements ConnectionHandler,
Closeable {
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNINITIALISED);
    private final URI uri;
    private final ExecutorService executor;
    private volatile long reconnectTimeMillis = 0L;
    private final Headers headers;
    private final EventSourceHandler eventSourceHandler;
    private final OkHttpClient client;
    private volatile Call call;
    public static final Logger log = LoggerFactory.getLogger(EventSource.class);
    private String lastEventId;

    public EventSource(URI uri, long reconnectTimeMillis, Headers headers, EventSourceHandler eventSourceHandler) {
        SSLSocketFactory sslSocketFactory;
        this.uri = uri;
        this.executor = Executors.newCachedThreadPool();
        this.reconnectTimeMillis = reconnectTimeMillis;
        this.headers = headers;
        this.eventSourceHandler = eventSourceHandler;
        try {
            X509TrustManager trustManager = this.trustManagerForCertificates(this.trustedCertificatesInputStream());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.client = new OkHttpClient().newBuilder().sslSocketFactory(sslSocketFactory).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public void init() {
        if (!this.state.compareAndSet(State.UNINITIALISED, State.CONNECTING)) {
            log.info("Already starting.");
        } else {
            log.debug("state change: " + (Object)((Object)State.UNINITIALISED) + " to " + (Object)((Object)State.CONNECTING));
            log.info("Starting EventSource client using URI: " + this.uri);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    EventSource.this.doConnect();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        Response response = null;
        block11: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted() && this.state.get() != State.SHUTDOWN) {
                    State currentState = this.state.getAndSet(State.CONNECTING);
                    log.debug("state change: " + (Object)((Object)currentState) + " to " + (Object)((Object)State.CONNECTING));
                    try {
                        Request.Builder ioe = new Request.Builder().headers(this.headers).url(this.uri.toASCIIString()).get();
                        if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                            ioe.addHeader("Last-Event-ID", this.lastEventId);
                        }
                        this.call = this.client.newCall(ioe.build());
                        response = this.call.execute();
                        if (response.isSuccessful()) {
                            String line;
                            currentState = this.state.getAndSet(State.OPEN);
                            if (currentState != State.CONNECTING) {
                                log.warn("Unexpected state change: " + (Object)((Object)currentState) + " to " + (Object)((Object)State.OPEN));
                            } else {
                                log.debug("state change: " + (Object)((Object)currentState) + " to " + (Object)((Object)State.OPEN));
                            }
                            log.info("Connected to Feature Control SSE Stream");
                            BufferedSource bs = Okio.buffer((Source)response.body().source());
                            EventSourceParser parser = new EventSourceParser(this.uri, this.eventSourceHandler, this);
                            while (!Thread.currentThread().isInterrupted() && (line = bs.readUtf8LineStrict()) != null) {
                                parser.line(line);
                            }
                        } else {
                            log.debug("Failed Response: " + response);
                            this.eventSourceHandler.onError(new FailedResponseException(response.code()));
                        }
                    }
                    catch (EOFException eof) {
                        log.warn("Connection unexpectedly closed due to {}.", (Object)eof.getMessage());
                    }
                    catch (IOException var15) {
                        log.debug("Connection problem.", (Throwable)var15);
                        this.eventSourceHandler.onError(var15);
                    }
                    finally {
                        currentState = this.state.getAndSet(State.CLOSED);
                        log.debug("state change: " + (Object)((Object)currentState) + " to " + (Object)((Object)State.CLOSED));
                        if (response != null && response.body() != null) {
                            response.body().close();
                        }
                        if (this.call != null) {
                            this.call.cancel();
                        }
                    }
                    if (this.reconnectTimeMillis <= 0L) continue;
                    log.info("Waiting to reconnect.." + this.reconnectTimeMillis);
                    try {
                        Thread.sleep(this.reconnectTimeMillis);
                        continue block11;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
                break;
            }
        }
    }

    @Override
    public void setReconnectionTimeMillis(long reconnectionTimeMillis) {
        this.reconnectTimeMillis = reconnectionTimeMillis;
    }

    @Override
    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    @Override
    public void close() throws IOException {
    }

    private InputStream trustedCertificatesInputStream() {
        String letsEncryptRootCa = "-----BEGIN CERTIFICATE-----\nMIIFCDCCA/CgAwIBAgISA7R03EyEk4Q9cB6bXqBQ3pe+MA0GCSqGSIb3DQEBCwUA\nMEoxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1MZXQncyBFbmNyeXB0MSMwIQYDVQQD\nExpMZXQncyBFbmNyeXB0IEF1dGhvcml0eSBYMzAeFw0xNzAyMjExMDMxMDBaFw0x\nNzA1MjIxMDMxMDBaMB0xGzAZBgNVBAMTEnJ0bS5mZWF0dXJlZmxvdy5pbzCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM4ofQz/i23IaUZO1BwqP4zyhirq\nEvxhC9SUBe2izectFZ0kMJfPyR7sTYu4wXEMSyu6IoltbbcZDnRWJAbkcwA3hqrb\nXEJCw5/dXeKh4EtmcXcoZLSiwiF7q3XUDJDBXapuiQlojqndH4fiovUCoQUq4lBn\nalUchUdPx3reQHfwENwxQHROldB2yOfxyR+JNYQtVEZ0putzhdDQ7djdI9xcZ0EP\nvXmw61/PHHPGbG1KBT71uPNocNLf4DYXvGoqsP5zcPh0nPBSofJS4yj2O3argtIK\nSHqLyDyoAopz6LAUnYKcrRheCmNMLCQUmTwMRYG295ZLwTEFxl9J66osNXECAwEA\nAaOCAhMwggIPMA4GA1UdDwEB/wQEAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYI\nKwYBBQUHAwIwDAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQUG2Vo0hyMNPakxPED6sTd\nqal6hpIwHwYDVR0jBBgwFoAUqEpqYwR93brm0Tm3pkVl7/Oo7KEwcAYIKwYBBQUH\nAQEEZDBiMC8GCCsGAQUFBzABhiNodHRwOi8vb2NzcC5pbnQteDMubGV0c2VuY3J5\ncHQub3JnLzAvBggrBgEFBQcwAoYjaHR0cDovL2NlcnQuaW50LXgzLmxldHNlbmNy\neXB0Lm9yZy8wHQYDVR0RBBYwFIIScnRtLmZlYXR1cmVmbG93LmlvMIH+BgNVHSAE\ngfYwgfMwCAYGZ4EMAQIBMIHmBgsrBgEEAYLfEwEBATCB1jAmBggrBgEFBQcCARYa\naHR0cDovL2Nwcy5sZXRzZW5jcnlwdC5vcmcwgasGCCsGAQUFBwICMIGeDIGbVGhp\ncyBDZXJ0aWZpY2F0ZSBtYXkgb25seSBiZSByZWxpZWQgdXBvbiBieSBSZWx5aW5n\nIFBhcnRpZXMgYW5kIG9ubHkgaW4gYWNjb3JkYW5jZSB3aXRoIHRoZSBDZXJ0aWZp\nY2F0ZSBQb2xpY3kgZm91bmQgYXQgaHR0cHM6Ly9sZXRzZW5jcnlwdC5vcmcvcmVw\nb3NpdG9yeS8wDQYJKoZIhvcNAQELBQADggEBAFlLnzLSonW8/+avm6xAQAowofz9\nDm87g2EkpFhuKEc9XG2c/j8rKtT2ATTche8NQ2Y3yX+W7a4WB3At8J+S0FpkeLig\no5zMUfgH6rrMETkvhAnMdRSdg2/Ug4Ijt5XeUGVLima8dd+f5hYzzuCnN9c0CFle\njQqVYgaYe/CIy0JBJ4OgJ/dUvzmrlPP7AHc2OVpo2DJKtVcSJ038ZIKa7q+5pibA\n74wMMfk1/w4wxBPJBash05bMw9n1uPLLMqCwOEsxO7LShbXW7r7Qg1aSoLD1T/BU\nlBaYcxRrcPCJyT9aWya3BkiWs7rxR0h1XIHy7XUNeJ5B94pZ2Wmkmx+Uo3s=\n-----END CERTIFICATE-----\n";
        String letsEncryptIntermediaryCa = "-----BEGIN CERTIFICATE-----\nMIIEkjCCA3qgAwIBAgIQCgFBQgAAAVOFc2oLheynCDANBgkqhkiG9w0BAQsFADA/\nMSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAMT\nDkRTVCBSb290IENBIFgzMB4XDTE2MDMxNzE2NDA0NloXDTIxMDMxNzE2NDA0Nlow\nSjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUxldCdzIEVuY3J5cHQxIzAhBgNVBAMT\nGkxldCdzIEVuY3J5cHQgQXV0aG9yaXR5IFgzMIIBIjANBgkqhkiG9w0BAQEFAAOC\nAQ8AMIIBCgKCAQEAnNMM8FrlLke3cl03g7NoYzDq1zUmGSXhvb418XCSL7e4S0EF\nq6meNQhY7LEqxGiHC6PjdeTm86dicbp5gWAf15Gan/PQeGdxyGkOlZHP/uaZ6WA8\nSMx+yk13EiSdRxta67nsHjcAHJyse6cF6s5K671B5TaYucv9bTyWaN8jKkKQDIZ0\nZ8h/pZq4UmEUEz9l6YKHy9v6Dlb2honzhT+Xhq+w3Brvaw2VFn3EK6BlspkENnWA\na6xK8xuQSXgvopZPKiAlKQTGdMDQMc2PMTiVFrqoM7hD8bEfwzB/onkxEz0tNvjj\n/PIzark5McWvxI0NHWQWM6r6hCm21AvA2H3DkwIDAQABo4IBfTCCAXkwEgYDVR0T\nAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAYYwfwYIKwYBBQUHAQEEczBxMDIG\nCCsGAQUFBzABhiZodHRwOi8vaXNyZy50cnVzdGlkLm9jc3AuaWRlbnRydXN0LmNv\nbTA7BggrBgEFBQcwAoYvaHR0cDovL2FwcHMuaWRlbnRydXN0LmNvbS9yb290cy9k\nc3Ryb290Y2F4My5wN2MwHwYDVR0jBBgwFoAUxKexpHsscfrb4UuQdf/EFWCFiRAw\nVAYDVR0gBE0wSzAIBgZngQwBAgEwPwYLKwYBBAGC3xMBAQEwMDAuBggrBgEFBQcC\nARYiaHR0cDovL2Nwcy5yb290LXgxLmxldHNlbmNyeXB0Lm9yZzA8BgNVHR8ENTAz\nMDGgL6AthitodHRwOi8vY3JsLmlkZW50cnVzdC5jb20vRFNUUk9PVENBWDNDUkwu\nY3JsMB0GA1UdDgQWBBSoSmpjBH3duubRObemRWXv86jsoTANBgkqhkiG9w0BAQsF\nAAOCAQEA3TPXEfNjWDjdGBX7CVW+dla5cEilaUcne8IkCJLxWh9KEik3JHRRHGJo\nuM2VcGfl96S8TihRzZvoroed6ti6WqEBmtzw3Wodatg+VyOeph4EYpr/1wXKtx8/\nwApIvJSwtmVi4MFU5aMqrSDE6ea73Mj2tcMyo5jMd6jmeWUHK8so/joWUoHOUgwu\nX4Po1QYz+3dszkDqMp4fklxBwXRsW10KXzPMTZ+sOPAveyxindmjkW8lGy+QsRlG\nPfZ+G6Z6h7mjem0Y+iWlkYcV4PIWL1iwBi8saCbGS5jN2p8M+X+Q7UNKEkROb3N6\nKOqkqm57TH2H3eDJAkSnh6/DNFu0Qg==\n-----END CERTIFICATE-----";
        return new Buffer().writeUtf8(letsEncryptRootCa).writeUtf8(letsEncryptIntermediaryCa).inputStream();
    }

    private X509TrustManager trustManagerForCertificates(InputStream in) throws GeneralSecurityException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("expected non-empty set of trusted certificates");
        }
        char[] password = "password".toCharArray();
        KeyStore keyStore = this.newEmptyKeyStore(password);
        int index = 0;
        for (Certificate certificate : certificates) {
            String certificateAlias = Integer.toString(index++);
            keyStore.setCertificateEntry(certificateAlias, certificate);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum State {
        UNINITIALISED,
        CONNECTING,
        OPEN,
        CLOSED,
        SHUTDOWN;

    }
}

