/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.FeatureflowContext;
import io.featureflow.client.core.CallbackEvent;
import io.featureflow.client.core.FeatureControlCache;
import io.featureflow.client.core.FeatureControlStreamClient;
import io.featureflow.client.core.FeatureEventHandler;
import io.featureflow.client.core.RestClient;
import io.featureflow.client.core.SimpleMemoryFeatureCache;
import io.featureflow.client.model.Event;
import io.featureflow.client.model.Feature;
import io.featureflow.client.model.FeatureControl;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureflowClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FeatureflowClient.class);
    private final FeatureflowConfig config;
    private final FeatureControlStreamClient featureControlStreamClient;
    private final FeatureControlCache featureControlCache;
    private final RestClient restClient;
    private final FeatureEventHandler eventHandler;
    private final Map<String, Feature> featuresMap = new HashMap<String, Feature>();
    private Queue<FeatureControlCallbackHandler> handlers;

    FeatureflowClient(String apiKey, List<Feature> features, FeatureflowConfig config, Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks) {
        this.config = config;
        this.featureControlCache = new SimpleMemoryFeatureCache();
        this.restClient = new RestClient(apiKey, config);
        this.eventHandler = new FeatureEventHandler(config, this.restClient);
        if (features != null && features.size() > 0) {
            for (Feature feature : features) {
                this.featuresMap.put(feature.key, feature);
            }
            try {
                this.restClient.registerFeatureControls(features);
            }
            catch (IOException e) {
                logger.error("Problem registering feature controls", (Throwable)e);
            }
        }
        this.featureControlStreamClient = new FeatureControlStreamClient(apiKey, config, this.featureControlCache, callbacks);
        Future<Void> startFuture = this.featureControlStreamClient.start();
        if (config.waitForStartup > 0L) {
            logger.info("Waiting for Featureflow to inititalise");
            try {
                startFuture.get(config.waitForStartup, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                logger.error("Timeout waiting for Featureflow client initialise");
            }
            catch (Exception e) {
                logger.error("Exception waiting for Featureflow client to initialise", (Throwable)e);
            }
        }
    }

    public Evaluate evaluate(String featureKey, FeatureflowContext featureflowContext) {
        Evaluate e = new Evaluate(this, featureKey, featureflowContext);
        return e;
    }

    public Evaluate evaluate(String featureKey) {
        FeatureflowContext featureflowContext = FeatureflowContext.context().build();
        return this.evaluate(featureKey, featureflowContext);
    }

    public Map<String, String> evaluateAll(FeatureflowContext featureflowContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : this.featureControlCache.getAll().keySet()) {
            result.put(s, this.eval(s, featureflowContext));
        }
        return result;
    }

    private String eval(String featureKey, FeatureflowContext featureflowContext) {
        String failoverVariant = this.featuresMap.get(featureKey) != null && this.featuresMap.get((Object)featureKey).failoverVariant != null ? this.featuresMap.get((Object)featureKey).failoverVariant : "off";
        FeatureControl control = this.featureControlCache.get(featureKey);
        if (!this.featureControlStreamClient.initialized()) {
            logger.warn("FeatureFlow is not initialized yet.");
        }
        if (control == null) {
            logger.warn("Control does not exist, returning failover variant of " + failoverVariant);
            return failoverVariant;
        }
        this.addAdditionalContext(featureflowContext);
        String variant = control.evaluate(featureflowContext);
        return variant;
    }

    private void addAdditionalContext(FeatureflowContext featureflowContext) {
        featureflowContext.values.put("featureflow.hourofday", (JsonElement)new JsonPrimitive((Number)LocalTime.now().getHour()));
        featureflowContext.values.put("featureflow.date", (JsonElement)new JsonPrimitive(FeatureflowContext.Builder.toIso(new DateTime())));
    }

    @Override
    public void close() throws IOException {
    }

    public static Builder builder(String apiKey) {
        return new Builder(apiKey);
    }

    public class Evaluate {
        private String evaluateResult;
        private String featureKey;
        private FeatureflowContext context;

        Evaluate(FeatureflowClient featureflowClient, String featureKey, FeatureflowContext featureflowContext) {
            this.featureKey = featureKey;
            this.context = featureflowContext;
            this.evaluateResult = featureflowClient.eval(featureKey, featureflowContext);
        }

        public boolean isOn() {
            return this.is("on");
        }

        public boolean isOff() {
            return this.is("off");
        }

        public boolean is(String variant) {
            FeatureflowClient.this.eventHandler.queueEvent(new Event(this.featureKey, "evaluate", this.context, this.evaluateResult, variant));
            return variant.equals(this.evaluateResult);
        }

        public String value() {
            FeatureflowClient.this.eventHandler.queueEvent(new Event(this.featureKey, "evaluate", this.context, this.evaluateResult, null));
            return this.evaluateResult;
        }
    }

    public static class Builder {
        private FeatureflowConfig config = null;
        private String apiKey;
        private Map<CallbackEvent, List<FeatureControlCallbackHandler>> featureControlCallbackHandlers = new HashMap<CallbackEvent, List<FeatureControlCallbackHandler>>();
        private List<Feature> features = new ArrayList<Feature>();

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder withUpdateCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withCallback(CallbackEvent.UPDATED_FEATURE, featureControlCallbackHandler);
            return this;
        }

        public Builder withDeleteCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withCallback(CallbackEvent.DELETED_FEATURE, featureControlCallbackHandler);
            return this;
        }

        @Deprecated
        public Builder withCallback(FeatureControlCallbackHandler featureControlCallbackHandler) {
            this.withUpdateCallback(featureControlCallbackHandler);
            return this;
        }

        public Builder withCallback(CallbackEvent event, FeatureControlCallbackHandler featureControlCallbackHandler) {
            if (this.featureControlCallbackHandlers.get((Object)event) == null) {
                this.featureControlCallbackHandlers.put(event, new ArrayList());
            }
            this.featureControlCallbackHandlers.get((Object)event).add(featureControlCallbackHandler);
            return this;
        }

        public Builder withConfig(FeatureflowConfig config) {
            this.config = config;
            return this;
        }

        public Builder withFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        public Builder withFeatures(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureflowClient build() {
            if (this.config == null) {
                this.config = new FeatureflowConfig.Builder().build();
            }
            return new FeatureflowClient(this.apiKey, this.features, this.config, this.featureControlCallbackHandlers);
        }
    }
}

