/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.featureflow.client.FeatureflowContext;
import io.featureflow.client.model.Operator;
import java.util.ArrayList;
import java.util.List;

public class Condition {
    public String target;
    public Operator operator;
    public List<JsonPrimitive> values = new ArrayList<JsonPrimitive>();

    public Condition() {
    }

    public Condition(String target, Operator operator, List<JsonPrimitive> values) {
        this.target = target;
        this.operator = operator;
        this.values = values;
    }

    public boolean matches(FeatureflowContext context) {
        if (context == null || context.values == null) {
            return false;
        }
        for (String key : context.values.keySet()) {
            if (!key.equals(this.target)) continue;
            JsonElement contextValue = context.values.get(key);
            if (contextValue.isJsonArray()) {
                JsonArray ar = contextValue.getAsJsonArray();
                for (JsonElement jsonElement : ar) {
                    if (!this.operator.evaluate(jsonElement.getAsJsonPrimitive(), this.values)) continue;
                    return true;
                }
                return false;
            }
            return this.operator.evaluate(context.values.get(key).getAsJsonPrimitive(), this.values);
        }
        return false;
    }
}

