/*
 * Decompiled with CFR 0.152.
 */
package io.featureflow.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.featureflow.client.FeatureControlCallbackHandler;
import io.featureflow.client.FeatureflowClient;
import io.featureflow.client.FeatureflowConfig;
import io.featureflow.client.FeatureflowContext;
import io.featureflow.client.core.CallbackEvent;
import io.featureflow.client.core.FeatureControlCache;
import io.featureflow.client.core.FeatureControlStreamClient;
import io.featureflow.client.core.FeatureEventHandler;
import io.featureflow.client.core.RestClient;
import io.featureflow.client.core.SimpleMemoryFeatureCache;
import io.featureflow.client.model.Event;
import io.featureflow.client.model.Feature;
import io.featureflow.client.model.FeatureControl;
import java.io.IOException;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureflowClientImpl
implements FeatureflowClient {
    private static final Logger logger = LoggerFactory.getLogger(FeatureflowClientImpl.class);
    private final FeatureflowConfig config;
    private final FeatureControlStreamClient featureControlStreamClient;
    private final FeatureControlCache featureControlCache;
    private final RestClient restClient;
    private final FeatureEventHandler eventHandler;
    private final Map<String, Feature> featuresMap = new HashMap<String, Feature>();
    private Queue<FeatureControlCallbackHandler> handlers;

    FeatureflowClientImpl(String apiKey, List<Feature> features, FeatureflowConfig config, Map<CallbackEvent, List<FeatureControlCallbackHandler>> callbacks) {
        this.config = config;
        this.featureControlCache = new SimpleMemoryFeatureCache();
        this.restClient = new RestClient(apiKey, config);
        this.eventHandler = new FeatureEventHandler(config, this.restClient);
        if (features != null && features.size() > 0) {
            for (Feature feature : features) {
                this.featuresMap.put(feature.key, feature);
            }
            try {
                this.restClient.registerFeatureControls(features);
            }
            catch (IOException e) {
                logger.error("Problem registering feature controls", (Throwable)e);
            }
        }
        this.featureControlStreamClient = new FeatureControlStreamClient(apiKey, config, this.featureControlCache, callbacks);
        Future<Void> startFuture = this.featureControlStreamClient.start();
        if (config.waitForStartup > 0L) {
            logger.info("Waiting for Featureflow to inititalise");
            try {
                startFuture.get(config.waitForStartup, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                logger.error("Timeout waiting for Featureflow client initialise");
            }
            catch (Exception e) {
                logger.error("Exception waiting for Featureflow client to initialise", (Throwable)e);
            }
        }
    }

    @Override
    public FeatureflowClient.Evaluate evaluate(String featureKey, FeatureflowContext featureflowContext) {
        FeatureflowClient.Evaluate e = new FeatureflowClient.Evaluate(this, featureKey, featureflowContext);
        return e;
    }

    @Override
    public FeatureflowClient.Evaluate evaluate(String featureKey) {
        FeatureflowContext featureflowContext = FeatureflowContext.context().build();
        return this.evaluate(featureKey, featureflowContext);
    }

    @Override
    public Map<String, String> evaluateAll(FeatureflowContext featureflowContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : this.featureControlCache.getAll().keySet()) {
            result.put(s, this.eval(s, featureflowContext));
        }
        return result;
    }

    protected String eval(String featureKey, FeatureflowContext featureflowContext) {
        FeatureControl control;
        String failoverVariant;
        String string = failoverVariant = this.featuresMap.get(featureKey) != null && this.featuresMap.get((Object)featureKey).failoverVariant != null ? this.featuresMap.get((Object)featureKey).failoverVariant : "off";
        if (!this.featureControlStreamClient.initialized()) {
            logger.warn("FeatureFlow is not initialized yet.");
            control = this.featureControlCache.get(featureKey);
            if (control == null) {
                return failoverVariant;
            }
        }
        control = this.featureControlCache.get(featureKey);
        this.addAdditionalContext(featureflowContext);
        if (control == null) {
            logger.error("Unknown Feature {}, returning failoverVariant value of {}", (Object)featureKey, (Object)failoverVariant);
            this.eventHandler.queueEvent(new Event(featureKey, "evaluate", featureflowContext, failoverVariant));
            return failoverVariant;
        }
        String variant = control.evaluate(featureflowContext);
        this.eventHandler.queueEvent(new Event(featureKey, "evaluate", featureflowContext, variant));
        return variant;
    }

    private void addAdditionalContext(FeatureflowContext featureflowContext) {
        featureflowContext.values.put("featureflow.hourofday", (JsonElement)new JsonPrimitive((Number)LocalTime.now().getHour()));
        featureflowContext.values.put("featureflow.date", (JsonElement)new JsonPrimitive(FeatureflowContext.Builder.toIso(new DateTime())));
    }

    @Override
    public void close() throws IOException {
    }
}

