/*
 * Decompiled with CFR 0.152.
 */
package io.fdev.plugin.gop.gmo.task.model.generator;

import io.fdev.plugin.gop.gmo.task.model.context.GmoModelContext;
import io.fdev.plugin.gop.gmo.task.model.generator.GmoGeneratorPredicates;
import io.fdev.plugin.gop.gmo.task.model.generator.GmoModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GmoModelGenerator {
    private static final Logger log = LoggerFactory.getLogger(GmoModelGenerator.class);
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("\\s*^\\s*$\\s*", 8);

    public void generate(GmoModelContext context) throws IOException {
        Path generatedOutPath = context.getGeneratedOutPath();
        if (Files.exists(generatedOutPath, new LinkOption[0])) {
            log.debug("Remove existing model");
            long count = Files.walk(generatedOutPath, new FileVisitOption[0]).map(Path::toFile).map(File::delete).count();
            log.debug("{} Removed files", (Object)count);
        } else {
            log.debug("Create out directory");
            Files.createDirectories(generatedOutPath, new FileAttribute[0]);
        }
        log.info("Generate DTO model");
        for (GmoModel gmoModel : this.createClassModels(context)) {
            String fileName = String.valueOf(gmoModel.getModelType()) + "Dto.java";
            Path modelPath = Path.of(generatedOutPath.toString(), fileName);
            Files.write(modelPath, List.of(gmoModel.generate()), StandardCharsets.UTF_16, new OpenOption[0]);
            log.trace("Generated {}", (Object)modelPath);
        }
    }

    private List<GmoModel> createClassModels(GmoModelContext context) {
        String[] entityRawDefinitions = EMPTY_LINE_PATTERN.split(context.getContextDefinition());
        return Stream.of(entityRawDefinitions).filter(GmoGeneratorPredicates.noTransient).map(def -> new GmoModel((String)def, context)).collect(Collectors.toList());
    }
}

