/*
 * Decompiled with CFR 0.152.
 */
package io.fdev.plugin.gop.gmo.task.model.generator;

import io.fdev.plugin.gop.gmo.task.model.context.GmoModelContext;
import io.fdev.plugin.gop.gmo.task.model.generator.GmoGeneratorPredicates;
import io.fdev.plugin.gop.gmo.task.model.generator.GmoModelMember;
import io.fdev.plugin.gop.gmo.task.model.generator.Model;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class GmoModel
implements Model {
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("^(def)?\\s*(\\S+)\\s*(\\w+)?\\s*(\\w+)?\\s*(?:(@desc)\\s*(.+))");
    private static final Pattern MEMBER_SPLIT_PATTERN = Pattern.compile("\\R");
    private final List<Model> members;
    private final GmoModelContext context;
    private String modelType;
    private String modelTable;
    private String modelDescription;

    GmoModel(String rawClassModel, GmoModelContext context) {
        this.defineModel(MEMBER_SPLIT_PATTERN.split(rawClassModel, 2)[0]);
        this.context = context;
        this.members = this.generateMembers(rawClassModel);
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildPackage());
        builder.append(this.buildClassDefinition());
        this.members.forEach(cm -> builder.append(cm.generate()));
        return builder.append("}").toString();
    }

    private void defineModel(String rawModelDefinition) {
        if ("/root".contains(rawModelDefinition)) {
            this.modelType = "BundleRoot";
            this.modelTable = "BUNDLE";
            this.modelDescription = "Root table, bundle holder";
        } else {
            Matcher matcher = DEFINITION_PATTERN.matcher(rawModelDefinition);
            while (matcher.find()) {
                this.modelType = matcher.group(2);
                this.modelTable = matcher.group(4);
                this.modelDescription = matcher.group(6);
            }
        }
    }

    private List<Model> generateMembers(String rawClassModel) {
        Map customFields = this.context.getCustomFields().getOrDefault(this.modelType, Map.of());
        Map<String, String> langFields = this.context.getLangFields();
        return rawClassModel.lines().skip(1L).filter(GmoGeneratorPredicates.noTransient).map(def -> new GmoModelMember((String)def, customFields, langFields)).collect(Collectors.toList());
    }

    private String buildPackage() {
        return "package " + this.context.getModelPackage() + System.lineSeparator().repeat(1);
    }

    private String buildClassDefinition() {
        return System.lineSeparator() + "@lombok.Data" + System.lineSeparator() + "public class " + this.modelType + "Dto implements java.io.Serializable  {" + System.lineSeparator().repeat(1);
    }

    public List<Model> getMembers() {
        return this.members;
    }

    public GmoModelContext getContext() {
        return this.context;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelTable() {
        return this.modelTable;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setModelTable(String modelTable) {
        this.modelTable = modelTable;
    }

    public void setModelDescription(String modelDescription) {
        this.modelDescription = modelDescription;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GmoModel)) {
            return false;
        }
        GmoModel other = (GmoModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Model> this$members = this.getMembers();
        List<Model> other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        GmoModelContext this$context = this.getContext();
        GmoModelContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$modelTable = this.getModelTable();
        String other$modelTable = other.getModelTable();
        if (this$modelTable == null ? other$modelTable != null : !this$modelTable.equals(other$modelTable)) {
            return false;
        }
        String this$modelDescription = this.getModelDescription();
        String other$modelDescription = other.getModelDescription();
        return !(this$modelDescription == null ? other$modelDescription != null : !this$modelDescription.equals(other$modelDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GmoModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Model> $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        GmoModelContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $modelTable = this.getModelTable();
        result = result * 59 + ($modelTable == null ? 43 : $modelTable.hashCode());
        String $modelDescription = this.getModelDescription();
        result = result * 59 + ($modelDescription == null ? 43 : $modelDescription.hashCode());
        return result;
    }

    public String toString() {
        return "GmoModel(members=" + this.getMembers() + ", context=" + this.getContext() + ", modelType=" + this.getModelType() + ", modelTable=" + this.getModelTable() + ", modelDescription=" + this.getModelDescription() + ")";
    }
}

