/*
 * Decompiled with CFR 0.152.
 */
package io.fdev.plugin.gop.gmo.task.download;

import io.fdev.plugin.gop.gmo.task.download.DownloadSuperpackExtension;
import io.fdev.plugin.gop.gmo.task.download.GopAuthenticator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class DownloadSuperpackTask
extends DefaultTask {
    private static final DateTimeFormatter SUPERPACK_DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private static final String MULTIPART_FORM_DATA_BOUNDARY = "superpack-export-definition";

    @TaskAction
    void downloadSuperpack() throws IOException, InterruptedException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DownloadSuperpackExtension extension = (DownloadSuperpackExtension)this.getProject().getExtensions().getByType(DownloadSuperpackExtension.class);
        HttpEntity multipartEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)new FileBody(Path.of(extension.getSuperpackDefinitionPath(), new String[0]).toFile())).setBoundary(MULTIPART_FORM_DATA_BOUNDARY).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(extension.getApiEndpoint())).header("Content-Type", "multipart/form-data; boundary=superpack-export-definition").POST(HttpRequest.BodyPublishers.ofInputStream(this.multipartStreamSupplier(multipartEntity))).build();
        System.out.println("downloading... keep calm");
        HttpClient.newBuilder().authenticator(new GopAuthenticator(extension)).build().send(request, HttpResponse.BodyHandlers.ofByteArrayConsumer(bytes -> bytes.ifPresent(output::writeBytes)));
        try (FileOutputStream outputStream = new FileOutputStream(this.buildSuperpackName(extension));){
            output.writeTo(outputStream);
        }
    }

    private Supplier<? extends InputStream> multipartStreamSupplier(HttpEntity multipartEntity) {
        return () -> {
            try {
                return multipartEntity.getContent();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
    }

    private String buildSuperpackName(DownloadSuperpackExtension extension) {
        Object name = "superpack_";
        name = (String)name + LocalDateTime.now().format(SUPERPACK_DATE_TIME_PATTERN);
        name = (String)name + ".zip";
        return extension.getDestinationPath() + File.separator + (String)name;
    }
}

