/*
 * Decompiled with CFR 0.152.
 */
package io.fdev.plugin.gop.gmo.task.model.generator;

import io.fdev.plugin.gop.gmo.task.model.generator.GmoGeneratorPredicates;
import io.fdev.plugin.gop.gmo.task.model.generator.Model;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GmoModelMember
implements Model {
    private static final Pattern PATTERN = Pattern.compile("(\\w+)\\s*(\\S+)\\s*(\\w+)?\\s*(\\w+)?\\s*(?:(@desc)\\s*(.+))");
    private String memberType;
    private String memberImport;
    private String memberName;
    private String memberColumn;
    private String memberDescription;

    GmoModelMember(String rawMember, Map<String, String> classCustomMembers, Map<String, String> langTypes) {
        Matcher matcher = PATTERN.matcher(rawMember);
        while (matcher.find()) {
            this.memberName = matcher.group(1);
            if (classCustomMembers.containsKey(this.memberName)) {
                this.memberType = classCustomMembers.get(this.memberName);
            } else {
                String type = matcher.group(2);
                this.memberType = langTypes.getOrDefault(type, type + "Dto");
                if (GmoGeneratorPredicates.isCollection.test(type)) {
                    this.memberType = GmoGeneratorPredicates.toRawList.apply(this.memberType);
                }
            }
            this.memberColumn = matcher.group(4);
            this.memberDescription = matcher.group(6);
        }
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("\t").append("/**").append(System.lineSeparator());
        builder.append("\t").append("* @description ").append(this.memberDescription).append(System.lineSeparator());
        if (Objects.nonNull(this.memberColumn)) {
            builder.append("\t").append("* @column ").append(this.memberColumn).append(System.lineSeparator());
        }
        builder.append("\t").append("**/").append(System.lineSeparator());
        builder.append("\t").append("private ").append(this.memberType).append(" ").append(this.memberName).append(";");
        builder.append("\t").append(System.lineSeparator());
        builder.append("\t").append(System.lineSeparator());
        return builder.toString();
    }

    public String getMemberType() {
        return this.memberType;
    }

    public String getMemberImport() {
        return this.memberImport;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberColumn() {
        return this.memberColumn;
    }

    public String getMemberDescription() {
        return this.memberDescription;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public void setMemberImport(String memberImport) {
        this.memberImport = memberImport;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public void setMemberColumn(String memberColumn) {
        this.memberColumn = memberColumn;
    }

    public void setMemberDescription(String memberDescription) {
        this.memberDescription = memberDescription;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GmoModelMember)) {
            return false;
        }
        GmoModelMember other = (GmoModelMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$memberType = this.getMemberType();
        String other$memberType = other.getMemberType();
        if (this$memberType == null ? other$memberType != null : !this$memberType.equals(other$memberType)) {
            return false;
        }
        String this$memberImport = this.getMemberImport();
        String other$memberImport = other.getMemberImport();
        if (this$memberImport == null ? other$memberImport != null : !this$memberImport.equals(other$memberImport)) {
            return false;
        }
        String this$memberName = this.getMemberName();
        String other$memberName = other.getMemberName();
        if (this$memberName == null ? other$memberName != null : !this$memberName.equals(other$memberName)) {
            return false;
        }
        String this$memberColumn = this.getMemberColumn();
        String other$memberColumn = other.getMemberColumn();
        if (this$memberColumn == null ? other$memberColumn != null : !this$memberColumn.equals(other$memberColumn)) {
            return false;
        }
        String this$memberDescription = this.getMemberDescription();
        String other$memberDescription = other.getMemberDescription();
        return !(this$memberDescription == null ? other$memberDescription != null : !this$memberDescription.equals(other$memberDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GmoModelMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $memberType = this.getMemberType();
        result = result * 59 + ($memberType == null ? 43 : $memberType.hashCode());
        String $memberImport = this.getMemberImport();
        result = result * 59 + ($memberImport == null ? 43 : $memberImport.hashCode());
        String $memberName = this.getMemberName();
        result = result * 59 + ($memberName == null ? 43 : $memberName.hashCode());
        String $memberColumn = this.getMemberColumn();
        result = result * 59 + ($memberColumn == null ? 43 : $memberColumn.hashCode());
        String $memberDescription = this.getMemberDescription();
        result = result * 59 + ($memberDescription == null ? 43 : $memberDescription.hashCode());
        return result;
    }

    public String toString() {
        return "GmoModelMember(memberType=" + this.getMemberType() + ", memberImport=" + this.getMemberImport() + ", memberName=" + this.getMemberName() + ", memberColumn=" + this.getMemberColumn() + ", memberDescription=" + this.getMemberDescription() + ")";
    }
}

