/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.spring.schema;

import com.alibaba.dubbo.config.AbstractInterfaceConfig;
import com.alibaba.dubbo.config.AbstractReferenceConfig;
import com.alibaba.dubbo.config.AbstractServiceConfig;
import eventcenter.api.async.QueueEventContainerFactory;
import eventcenter.builder.AggregatorContainerBuilder;
import eventcenter.builder.EventCenterBuilder;
import eventcenter.builder.LevelDBContainerBuilder;
import eventcenter.builder.MonitorConfig;
import eventcenter.builder.dubbo.DubboConfigContext;
import eventcenter.builder.dubbo.DubboPublisherConfigBuilder;
import eventcenter.builder.dubbo.DubboPublisherGroupBuilder;
import eventcenter.builder.dubbo.DubboSubscriberConfigBuilder;
import eventcenter.builder.dubbo.EventSubscriberServiceConfig;
import eventcenter.builder.dubbo.EventTransmissionReferenceConfig;
import eventcenter.builder.monitor.log.LogMonitorConfigBuilder;
import eventcenter.builder.monitor.mixing.MixingMonitorConfigBuilder;
import eventcenter.builder.monitor.mysql.MysqlMonitorConfigBuilder;
import eventcenter.builder.saf.SimpleSAFPolicyBuilder;
import eventcenter.builder.saf.leveldb.LeveldbSAFPolicyBuilder;
import eventcenter.builder.spring.EventCenterFactoryBean;
import eventcenter.builder.spring.schema.NodeAttribute;
import eventcenter.remote.saf.StoreAndForwardPolicy;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventCenterBeanDefinitionParser
implements BeanDefinitionParser {
    static final String FACTORY_BEAN_NAME = "eventCenterBuilder";
    static final String FACTORY_BEAN_METHOD = "build";
    static final String ELEMENT_QUEUE = "queue";
    static final String ELEMENT_SIMPLE_QUEUE_CONTAINER = "simpleQueueContainer";
    static final String ELEMENT_LEVELDB_QUEUE_CONTAINER = "leveldbQueueContainer";
    static final String ELEMENT_AGGREGATOR = "aggregator";
    static final String ELEMENT_AGGREGATOR_MULTI = "multi";
    static final String ELEMENT_AGGREGATOR_THREADPOOL_INFO = "threadPoolInfo";
    static final String ELEMENT_DUBBO = "dubbo";
    static final String ELEMENT_DUBBO_PUBLISH = "dubboPublish";
    static final String ELEMENT_DUBBO_SUBSCRIBE = "dubboSubscribe";
    static final String ELEMENT_DUBBO_PUBLISH_GROUP = "dubboPublishGroup";
    static final String ELEMENT_EVENT_TRANSMISSION = "eventTransmission";
    static final String ELEMENT_SAF = "saf";
    static final String ELEMENT_SAF_SIMPLE = "simpleSaf";
    static final String ELEMENT_SAF_LEVELDB = "leveldbSaf";
    static final String ELEMENT_LOG_MONITOR = "logMonitor";
    static final String ELEMENT_MYSQL_MONITOR = "mysqlMonitor";
    static final String ELEMENT_MIXING_MONITOR = "mixingMonitor";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(EventCenterFactoryBean.class);
        beanDefinition.setInitMethodName("startup");
        beanDefinition.setDestroyMethodName("shutdown");
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = "eventCenter";
        }
        beanDefinition.getPropertyValues().add("builder", (Object)this.createEventCenterBuilder(element));
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    EventCenterBuilder createEventCenterBuilder(Element element) {
        EventCenterBuilder builder = new EventCenterBuilder();
        String openLoggerMdc = element.getAttribute("openLoggerMdc");
        String loggerMdcField = element.getAttribute("loggerMdcField");
        String group = element.getAttribute("group");
        if (StringUtils.hasText((String)openLoggerMdc)) {
            builder.openLoggerMdc(Boolean.parseBoolean(openLoggerMdc));
        }
        if (StringUtils.hasText((String)loggerMdcField)) {
            builder.loggerMdcField(loggerMdcField);
        }
        if (StringUtils.hasText((String)group)) {
            DubboConfigContext.getInstance().groupName(group);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (ELEMENT_QUEUE.equals(node.getLocalName())) {
                builder = this.createQueueContainer(builder, node);
                continue;
            }
            if (ELEMENT_AGGREGATOR.equals(node.getLocalName())) {
                builder = this.createAggregator(builder, node);
                continue;
            }
            if (ELEMENT_DUBBO.equals(node.getLocalName())) {
                builder = this.createDubbo(builder, node);
                continue;
            }
            if (ELEMENT_SAF.equals(node.getLocalName())) {
                builder = this.createSaf(builder, node);
                continue;
            }
            if (ELEMENT_LOG_MONITOR.equals(node.getLocalName())) {
                builder.monitor(this.createLogMonitor(builder, node));
                continue;
            }
            if (ELEMENT_MYSQL_MONITOR.equals(node.getLocalName())) {
                builder.monitor(this.createMysqlMonitor(builder, node));
                continue;
            }
            if (!ELEMENT_MIXING_MONITOR.equals(node.getLocalName())) continue;
            builder.monitor(this.createMixingMonitor(builder, node));
        }
        return builder;
    }

    EventCenterBuilder createDubbo(EventCenterBuilder builder, Node node) {
        String applicationName = this.getAttribute(node, "applicationName");
        String applicationOwner = this.getAttribute(node, "applicationOwner");
        String protocolName = this.getAttribute(node, "protocolName");
        String protocolHost = this.getAttribute(node, "protocolHost");
        String protocolPort = this.getAttribute(node, "protocolPort");
        String registryProtocol = this.getAttribute(node, "registryProtocol");
        String registryAddress = this.getAttribute(node, "registryAddress");
        String registryUsername = this.getAttribute(node, "registryUsername");
        String registryPassword = this.getAttribute(node, "registryPassword");
        if (StringUtils.hasText((String)applicationName)) {
            DubboConfigContext.getInstance().applicationName(applicationName);
        }
        if (StringUtils.hasText((String)applicationOwner)) {
            DubboConfigContext.getInstance().applicationOwner(applicationOwner);
        }
        if (StringUtils.hasText((String)protocolName)) {
            DubboConfigContext.getInstance().protocolName(protocolName);
        }
        if (StringUtils.hasText((String)protocolHost)) {
            DubboConfigContext.getInstance().protocolHost(protocolHost);
        }
        if (StringUtils.hasText((String)protocolPort)) {
            DubboConfigContext.getInstance().protocolPort(Integer.parseInt(protocolPort));
        }
        if (StringUtils.hasText((String)registryProtocol)) {
            DubboConfigContext.getInstance().registryProtocol(registryProtocol);
        }
        if (StringUtils.hasText((String)registryAddress)) {
            DubboConfigContext.getInstance().registryAddress(registryAddress);
        }
        if (StringUtils.hasText((String)registryUsername)) {
            DubboConfigContext.getInstance().registryUsername(registryUsername);
        }
        if (StringUtils.hasText((String)registryPassword)) {
            DubboConfigContext.getInstance().registryPassword(registryPassword);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (ELEMENT_DUBBO_PUBLISH.equals(subNode.getLocalName())) {
                builder.publisher(this.createDubboPublish(subNode).build());
                continue;
            }
            if (!ELEMENT_DUBBO_SUBSCRIBE.equals(subNode.getLocalName())) continue;
            builder.subscriber(this.createDubboSubscriberConfig(subNode).build());
        }
        return builder;
    }

    DubboPublisherConfigBuilder createDubboPublish(Node node) {
        DubboPublisherConfigBuilder builder = new DubboPublisherConfigBuilder();
        String localEventNames = this.getAttribute(node, "localEventNames");
        String group = this.getAttribute(node, "group");
        String asyncFireRemote = this.getAttribute(node, "asyncFireRemote");
        String copySendUnderSameVersion = this.getAttribute(node, "copySendUnderSameVersion");
        String devMode = this.getAttribute(node, "devMode");
        String expiryOffline = this.getAttribute(node, "expiryOffline");
        String subscriberAutowired = this.getAttribute(node, "subscriberAutowired");
        if (StringUtils.hasText((String)localEventNames)) {
            builder.addLocalPublisherGroup(localEventNames);
        }
        if (StringUtils.hasText((String)group)) {
            builder.groupName(group);
        }
        if (StringUtils.hasText((String)asyncFireRemote)) {
            builder.asyncFireRemote(Boolean.parseBoolean(asyncFireRemote));
        }
        if (StringUtils.hasText((String)copySendUnderSameVersion)) {
            builder.copySendUnderSameVersion(Boolean.parseBoolean(copySendUnderSameVersion));
        }
        if (StringUtils.hasText((String)devMode)) {
            builder.devMode(Boolean.parseBoolean(devMode));
        }
        if (StringUtils.hasText((String)expiryOffline)) {
            builder.expiryOffline(Long.parseLong(expiryOffline));
        }
        if (StringUtils.hasText((String)subscriberAutowired)) {
            builder.subscriberAutowired(Boolean.parseBoolean(subscriberAutowired));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!ELEMENT_DUBBO_PUBLISH_GROUP.equals(subNode.getLocalName())) continue;
            builder.addPublisherGroup(this.createDubboPublisherGroup(subNode));
        }
        return builder;
    }

    DubboPublisherGroupBuilder createDubboPublisherGroup(Node node) {
        DubboPublisherGroupBuilder builder = new DubboPublisherGroupBuilder();
        String group = this.getAttribute(node, "group");
        String remoteEvents = this.getAttribute(node, "remoteEvents");
        if (StringUtils.hasText((String)group)) {
            builder.groupName(group);
        }
        if (StringUtils.hasText((String)remoteEvents)) {
            builder.remoteEvents(remoteEvents);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!ELEMENT_EVENT_TRANSMISSION.equals(subNode.getLocalName())) continue;
            builder.eventTransmission(this.buildEventTransmissionReferenceConfig(subNode));
        }
        return builder;
    }

    DubboSubscriberConfigBuilder createDubboSubscriberConfig(Node node) {
        DubboSubscriberConfigBuilder builder = new DubboSubscriberConfigBuilder();
        String subscribeEvents = this.getAttribute(node, "eventNames");
        String dubboVersion = this.getAttribute(node, "version");
        if (StringUtils.hasText((String)subscribeEvents)) {
            builder.addSubscriber(subscribeEvents);
        }
        if (StringUtils.isEmpty((Object)dubboVersion) && (node.getChildNodes() == null || node.getChildNodes().getLength() == 0)) {
            throw new IllegalArgumentException("please set dubboSubscriberServiceConfig node in dubboSubscribe");
        }
        return builder.eventSubscriberServiceConfig(this.buildEventSubscriberServiceConfig(node.getFirstChild(), dubboVersion));
    }

    EventSubscriberServiceConfig buildEventSubscriberServiceConfig(Node node, String dubboVersion) {
        EventSubscriberServiceConfig config = new EventSubscriberServiceConfig();
        if (node != null) {
            this.copyAbstractServiceConfig(config, new NodeAttribute(node));
            String checkHealthTimeout = this.getAttribute(node, "checkHealthTimeout");
            if (StringUtils.hasText((String)checkHealthTimeout)) {
                config.setCheckHealthTimeout(Integer.parseInt(checkHealthTimeout));
            }
        }
        config.setVersion(dubboVersion);
        return config;
    }

    void copyAbstractInterfaceConfig(AbstractInterfaceConfig config, NodeAttribute a) {
        config.setActives(a.getAttributeInteger("actives"));
        config.setCache(a.getAttribute("cache"));
        config.setCallbacks(a.getAttributeInteger("callbacks"));
        config.setCluster(a.getAttribute("cluster"));
        config.setConnections(a.getAttributeInteger("connections"));
        config.setFilter(a.getAttribute("filter"));
        config.setId(a.getAttribute("id"));
        config.setLayer(a.getAttribute("layer"));
        config.setListener(a.getAttribute("listener"));
        config.setLoadbalance(a.getAttribute("localbalance"));
        config.setMerger(a.getAttribute("merger"));
        config.setMock(a.getAttribuetBoolean("mock"));
        config.setMonitor(a.getAttribute("monitor"));
        config.setOnconnect(a.getAttribute("onconnect"));
        config.setOndisconnect(a.getAttribute("ondisconnect"));
        config.setOwner(a.getAttribute("owner"));
        config.setProxy(a.getAttribute("proxy"));
        config.setRetries(a.getAttributeInteger("retries"));
        config.setScope(a.getAttribute("scope"));
        config.setSent(a.getAttribuetBoolean("sent"));
        config.setStub(a.getAttribuetBoolean("stub"));
        config.setTimeout(a.getAttributeInteger("timeout"));
        config.setValidation(a.getAttribute("validation"));
    }

    void copyAbstractServiceConfig(AbstractServiceConfig config, NodeAttribute a) {
        this.copyAbstractInterfaceConfig((AbstractInterfaceConfig)config, a);
        config.setVersion(a.getAttribute("version"));
        config.setGroup(a.getAttribute("group"));
        config.setDeprecated(a.getAttribuetBoolean("deprecated"));
        config.setDelay(a.getAttributeInteger("deplay"));
        config.setExport(a.getAttribuetBoolean("export"));
        config.setWeight(a.getAttributeInteger("weight"));
        config.setDocument(a.getAttribute("document"));
        config.setDynamic(a.getAttribuetBoolean("dynamic"));
        config.setToken(a.getAttribuetBoolean("token"));
        config.setAccesslog(a.getAttribuetBoolean("accessLog"));
        config.setExecutes(a.getAttributeInteger("executes"));
    }

    void copyAbstractReferenceConfig(AbstractReferenceConfig config, NodeAttribute a) {
        this.copyAbstractInterfaceConfig((AbstractInterfaceConfig)config, a);
        config.setAsync(a.getAttribuetBoolean("async"));
        config.setCheck(a.getAttribuetBoolean("check"));
        config.setGeneric(a.getAttribuetBoolean("generic"));
        config.setInit(a.getAttribuetBoolean("init"));
        config.setReconnect(a.getAttribute("reconnect"));
        config.setSticky(a.getAttribuetBoolean("stricky"));
        config.setVersion(a.getAttribute("version"));
    }

    EventTransmissionReferenceConfig buildEventTransmissionReferenceConfig(Node node) {
        EventTransmissionReferenceConfig config = new EventTransmissionReferenceConfig();
        NodeAttribute a = new NodeAttribute(node);
        config.setClient(a.getAttribute("client"));
        config.setProtocol(a.getAttribute("protocol"));
        config.setUrl(a.getAttribute("url"));
        this.copyAbstractReferenceConfig((AbstractReferenceConfig)config, a);
        if ((StringUtils.isEmpty((Object)config.getVersion()) || "0.0.0".equals(config.getVersion())) && StringUtils.isEmpty((Object)config.getUrl())) {
            throw new IllegalArgumentException("please set version or url in node of eventTransmission");
        }
        return config;
    }

    EventCenterBuilder createAggregator(EventCenterBuilder builder, Node node) {
        AggregatorContainerBuilder containerBuilder = new AggregatorContainerBuilder();
        String corePoolSize = this.getAttribute(node, "corePoolSize");
        String maximumPoolSize = this.getAttribute(node, "maximumPoolSize");
        containerBuilder.simpleAggregatorContainer(Integer.parseInt(corePoolSize), Integer.parseInt(maximumPoolSize));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!ELEMENT_AGGREGATOR_MULTI.equals(subNode.getLocalName())) continue;
            containerBuilder = this.createAggregatorThreadPoolInfos(containerBuilder, subNode);
        }
        builder.aggregatorContainer(containerBuilder.build());
        return builder;
    }

    AggregatorContainerBuilder createAggregatorThreadPoolInfos(AggregatorContainerBuilder builder, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!ELEMENT_AGGREGATOR_THREADPOOL_INFO.equals(subNode.getLocalName())) continue;
            builder = this.createAggregatorThreadPoolInfo(builder, subNode);
        }
        return builder;
    }

    AggregatorContainerBuilder createAggregatorThreadPoolInfo(AggregatorContainerBuilder builder, Node node) {
        String eventNames = this.getAttribute(node, "eventNames");
        String corePoolSize = this.getAttribute(node, "corePoolSize");
        String maximumPoolSize = this.getAttribute(node, "maximumPoolSize");
        builder.threadPoolInfo(eventNames, Integer.parseInt(corePoolSize), Integer.parseInt(maximumPoolSize));
        return builder;
    }

    EventCenterBuilder createSaf(EventCenterBuilder builder, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (ELEMENT_SAF_SIMPLE.equals(subNode.getLocalName())) {
                builder = this.buildSimpleSaf(builder, subNode);
                continue;
            }
            if (!ELEMENT_SAF_LEVELDB.equals(subNode.getLocalName())) continue;
            builder = this.buildLeveldbSaf(builder, subNode);
        }
        return builder;
    }

    EventCenterBuilder buildSimpleSaf(EventCenterBuilder builder, Node node) {
        SimpleSAFPolicyBuilder policyBuilder = new SimpleSAFPolicyBuilder();
        String storeOnSendFail = this.getAttribute(node, "storeOnSendFail");
        String checkInterval = this.getAttribute(node, "checkInterval");
        String queueCapacity = this.getAttribute(node, "queueCapacity");
        if (StringUtils.hasText((String)storeOnSendFail)) {
            policyBuilder.storeOnSendFail(Boolean.parseBoolean(storeOnSendFail));
        }
        if (StringUtils.hasText((String)checkInterval)) {
            policyBuilder.checkInterval(Long.parseLong(checkInterval));
        }
        if (StringUtils.hasText((String)queueCapacity)) {
            policyBuilder.queueCapacity(Integer.parseInt(queueCapacity));
        }
        return builder.safPolicy((StoreAndForwardPolicy)policyBuilder.build());
    }

    EventCenterBuilder buildLeveldbSaf(EventCenterBuilder builder, Node node) {
        LeveldbSAFPolicyBuilder policyBuilder = new LeveldbSAFPolicyBuilder();
        String storeOnSendFail = this.getAttribute(node, "storeOnSendFail");
        String checkInterval = this.getAttribute(node, "checkInterval");
        String path = this.getAttribute(node, "path");
        String readLimitSize = this.getAttribute(node, "readLimitSize");
        String levelDBName = this.getAttribute(node, "levelDBName");
        String houseKeepingInterval = this.getAttribute(node, "houseKeepingInterval");
        if (StringUtils.hasText((String)storeOnSendFail)) {
            policyBuilder.storeOnSendFail(Boolean.parseBoolean(storeOnSendFail));
        }
        if (StringUtils.hasText((String)checkInterval)) {
            policyBuilder.checkInterval(Long.parseLong(checkInterval));
        }
        if (StringUtils.hasText((String)path)) {
            policyBuilder.path(path);
        }
        if (StringUtils.hasText((String)readLimitSize)) {
            policyBuilder.readLimitSize(Integer.parseInt(readLimitSize));
        }
        if (StringUtils.hasText((String)levelDBName)) {
            policyBuilder.levelDBName(levelDBName);
        }
        if (StringUtils.hasText((String)houseKeepingInterval)) {
            policyBuilder.houseKeepingInterval(Long.parseLong(houseKeepingInterval));
        }
        return builder.safPolicy((StoreAndForwardPolicy)policyBuilder.build());
    }

    EventCenterBuilder createQueueContainer(EventCenterBuilder builder, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (ELEMENT_SIMPLE_QUEUE_CONTAINER.equals(subNode.getLocalName())) {
                builder = this.createSimpleQueueContainer(builder, subNode);
                continue;
            }
            if (!ELEMENT_LEVELDB_QUEUE_CONTAINER.equals(subNode.getLocalName())) continue;
            builder = this.createLeveldbQueueContainer(builder, subNode);
        }
        return builder;
    }

    EventCenterBuilder createSimpleQueueContainer(EventCenterBuilder builder, Node node) {
        String corePoolSize = this.getAttribute(node, "corePoolSize");
        String queueCapacity = this.getAttribute(node, "queueCapacity");
        String maximumPoolSize = this.getAttribute(node, "maximumPoolSize");
        if (StringUtils.hasText((String)corePoolSize) && StringUtils.hasText((String)queueCapacity) && StringUtils.hasText((String)maximumPoolSize)) {
            builder.simpleQueueContainer(Integer.parseInt(corePoolSize), Integer.parseInt(queueCapacity), Integer.parseInt(maximumPoolSize));
        } else if (StringUtils.hasText((String)corePoolSize) && StringUtils.hasText((String)queueCapacity)) {
            builder.simpleQueueContainer(Integer.parseInt(corePoolSize), Integer.parseInt(queueCapacity));
        } else if (StringUtils.hasText((String)corePoolSize)) {
            builder.simpleQueueContainer(Integer.parseInt(corePoolSize));
        }
        return builder;
    }

    EventCenterBuilder createLeveldbQueueContainer(EventCenterBuilder builder, Node node) {
        String corePoolSize = this.getAttribute(node, "corePoolSize");
        String maximumPoolSize = this.getAttribute(node, "maximumPoolSize");
        String checkInterval = this.getAttribute(node, "checkInterval");
        String path = this.getAttribute(node, "path");
        String levelDBName = this.getAttribute(node, "levelDBName");
        String readLimitSize = this.getAttribute(node, "readLimitSize");
        String openTxn = this.getAttribute(node, "openTxn");
        String keepAliveTime = this.getAttribute(node, "keepAliveTime");
        String blockingQueueFactor = this.getAttribute(node, "blockingQueueFactor");
        String loopQueueInterval = this.getAttribute(node, "loopQueueInterval");
        String openLevelDbLog = this.getAttribute(node, "openLevelDbLog");
        LevelDBContainerBuilder containerBuilder = new LevelDBContainerBuilder();
        if (StringUtils.hasText((String)corePoolSize)) {
            containerBuilder.corePoolSize(Integer.parseInt(corePoolSize));
        }
        if (StringUtils.hasText((String)maximumPoolSize)) {
            containerBuilder.maximumPoolSize(Integer.parseInt(maximumPoolSize));
        }
        if (StringUtils.hasText((String)path)) {
            containerBuilder.path(path);
        }
        if (StringUtils.hasText((String)checkInterval)) {
            containerBuilder.checkInterval(Long.parseLong(checkInterval));
        }
        if (StringUtils.hasText((String)levelDBName)) {
            containerBuilder.levelDBName(levelDBName);
        }
        if (StringUtils.hasText((String)readLimitSize)) {
            containerBuilder.readLimitSize(Integer.parseInt(readLimitSize));
        }
        if (StringUtils.hasText((String)openTxn)) {
            containerBuilder.openTxn(Boolean.parseBoolean(openTxn));
        }
        if (StringUtils.hasText((String)keepAliveTime)) {
            containerBuilder.keepAliveTime(Integer.parseInt(keepAliveTime));
        }
        if (StringUtils.hasText((String)blockingQueueFactor)) {
            containerBuilder.blockingQueueFactor(Integer.parseInt(blockingQueueFactor));
        }
        if (StringUtils.hasText((String)loopQueueInterval)) {
            containerBuilder.loopQueueInterval(Long.parseLong(loopQueueInterval));
        }
        if (StringUtils.hasText((String)openLevelDbLog)) {
            containerBuilder.openLevelDbLog(Boolean.parseBoolean(openLevelDbLog));
        }
        return builder.queueContainerFactory((QueueEventContainerFactory)containerBuilder.build());
    }

    MonitorConfig createLogMonitor(EventCenterBuilder builder, Node node) {
        LogMonitorConfigBuilder configBuilder = new LogMonitorConfigBuilder();
        String nodeName = this.getAttribute(node, "nodeName");
        String saveEventData = this.getAttribute(node, "saveEventData");
        String heartbeatInterval = this.getAttribute(node, "heartbeatInterval");
        if (StringUtils.hasText((String)nodeName)) {
            configBuilder.nodeName(nodeName);
        }
        if (StringUtils.hasText((String)saveEventData)) {
            configBuilder.saveEventData(Boolean.parseBoolean(saveEventData));
        }
        if (StringUtils.hasText((String)heartbeatInterval)) {
            configBuilder.heartbeatInterval(Long.parseLong(heartbeatInterval));
        }
        return configBuilder.build();
    }

    MonitorConfig createMysqlMonitor(EventCenterBuilder builder, Node node) {
        MysqlMonitorConfigBuilder configBuilder = new MysqlMonitorConfigBuilder();
        String nodeName = this.getAttribute(node, "nodeName");
        String saveEventData = this.getAttribute(node, "saveEventData");
        String heartbeatInterval = this.getAttribute(node, "heartbeatInterval");
        String dataSourceBeanId = this.getAttribute(node, "dataSourceBeanId");
        if (StringUtils.hasText((String)nodeName)) {
            configBuilder.nodeName(nodeName);
        }
        if (StringUtils.hasText((String)saveEventData)) {
            configBuilder.saveEventData(Boolean.parseBoolean(saveEventData));
        }
        if (StringUtils.hasText((String)heartbeatInterval)) {
            configBuilder.heartbeatInterval(Long.parseLong(heartbeatInterval));
        }
        if (StringUtils.hasText((String)dataSourceBeanId)) {
            configBuilder.dataSourceBeanId(dataSourceBeanId);
        }
        return configBuilder.build();
    }

    MonitorConfig createMixingMonitor(EventCenterBuilder builder, Node node) {
        MixingMonitorConfigBuilder configBuilder = new MixingMonitorConfigBuilder();
        String nodeName = this.getAttribute(node, "nodeName");
        String saveEventData = this.getAttribute(node, "saveEventData");
        String heartbeatInterval = this.getAttribute(node, "heartbeatInterval");
        if (StringUtils.hasText((String)nodeName)) {
            configBuilder.nodeName(nodeName);
        }
        if (StringUtils.hasText((String)saveEventData)) {
            configBuilder.saveEventData(Boolean.parseBoolean(saveEventData));
        }
        if (StringUtils.hasText((String)heartbeatInterval)) {
            configBuilder.heartbeatInterval(Long.parseLong(heartbeatInterval));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (ELEMENT_LOG_MONITOR.equals(subNode.getLocalName())) {
                configBuilder.addMonitorConfig(this.createLogMonitor(builder, subNode));
                continue;
            }
            if (!ELEMENT_MYSQL_MONITOR.equals(subNode.getLocalName())) continue;
            configBuilder.addMonitorConfig(this.createMysqlMonitor(builder, subNode));
        }
        return configBuilder.build();
    }

    String getAttribute(Node node, String key) {
        if (null == node.getAttributes()) {
            return null;
        }
        Node namedItem = node.getAttributes().getNamedItem(key);
        if (null == namedItem) {
            return null;
        }
        return namedItem.getNodeValue();
    }
}

