/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.monitor.mysql;

import eventcenter.api.support.DefaultEventCenter;
import eventcenter.builder.MonitorConfig;
import eventcenter.monitor.AbstractControlMonitor;
import eventcenter.monitor.mysql.MySqlControlMonitor;
import eventcenter.monitor.mysql.MySqlEventFireFilter;
import eventcenter.monitor.mysql.MySqlSubscriberStartupFilter;
import javax.sql.DataSource;

public class MysqlMonitorConfig
extends MonitorConfig {
    private static final long serialVersionUID = 4711485326129011533L;
    protected DataSource dataSource;
    protected String dataSourceBeanId;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    protected AbstractControlMonitor createControlMonitor(DefaultEventCenter eventCenter, boolean subscriber) {
        MySqlControlMonitor monitor = new MySqlControlMonitor();
        monitor.setControlMonitorDataSource(this.dataSource);
        return monitor;
    }

    @Override
    protected void loadFilters(AbstractControlMonitor controlMonitor, DefaultEventCenter eventCenter, boolean subscriber) {
        super.loadFilters(controlMonitor, eventCenter, subscriber);
        MySqlEventFireFilter mySqlEventFireFilter = new MySqlEventFireFilter();
        mySqlEventFireFilter.setControlMonitorDataSource(this.dataSource);
        mySqlEventFireFilter.startUp();
        eventCenter.getEcConfig().getModuleFilters().add(mySqlEventFireFilter);
        if (subscriber) {
            MySqlSubscriberStartupFilter mySqlSubscriberStartupFilter = new MySqlSubscriberStartupFilter();
            mySqlSubscriberStartupFilter.setControlMonitorDataSource(this.dataSource);
            eventCenter.getEcConfig().getModuleFilters().add(mySqlSubscriberStartupFilter);
        }
    }

    public String getDataSourceBeanId() {
        return this.dataSourceBeanId;
    }

    public void setDataSourceBeanId(String dataSourceBeanId) {
        this.dataSourceBeanId = dataSourceBeanId;
    }
}

