/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.AbstractServiceConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import eventcenter.remote.EventTransmission;
import eventcenter.remote.subscriber.EventSubscriber;
import eventcenter.remote.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class EventSubscriberServiceConfig
extends AbstractServiceConfig {
    private static final long serialVersionUID = 1435544645200451405L;
    private Class<?> interfaceClass;
    private String path;
    private ProviderConfig provider;
    private final List<URL> urls = new ArrayList<URL>();
    protected Integer checkHealthTimeout;
    private ServiceConfig<eventcenter.remote.EventSubscriber> eventSubscriberConfig;
    private ServiceConfig<EventTransmission> eventTransmissionConfig;

    void load(EventSubscriber eventSubscriber, boolean loadSubscriber) {
        this.eventTransmissionConfig = new ServiceConfig();
        this.copyServiceConfig(this.eventTransmissionConfig);
        this.loadEventTransmission();
        this.eventTransmissionConfig.setRetries(Integer.valueOf(0));
        this.eventTransmissionConfig.setInterface(EventTransmission.class);
        this.eventTransmissionConfig.setRef((Object)eventSubscriber);
        this.eventTransmissionConfig.export();
        if (loadSubscriber) {
            this.eventSubscriberConfig = new ServiceConfig();
            this.copyServiceConfig(this.eventSubscriberConfig);
            this.eventSubscriberConfig.setInterface(eventcenter.remote.EventSubscriber.class);
            this.eventSubscriberConfig.setRef((Object)eventSubscriber);
            this.eventSubscriberConfig.export();
        }
    }

    void loadEventTransmission() {
        ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>(2);
        MethodConfig m1 = new MethodConfig();
        m1.setName("asyncTransmission");
        m1.setAsync(Boolean.valueOf(true));
        methodConfigs.add(m1);
        MethodConfig m2 = new MethodConfig();
        m2.setName("checkHealth");
        m2.setTimeout(Integer.valueOf(this.checkHealthTimeout == null ? 1000 : this.checkHealthTimeout));
        methodConfigs.add(m2);
        this.eventTransmissionConfig.setMethods(methodConfigs);
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ProviderConfig getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderConfig provider) {
        this.provider = provider;
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public Integer getCheckHealthTimeout() {
        return this.checkHealthTimeout;
    }

    public void setCheckHealthTimeout(Integer checkHealthTimeout) {
        this.checkHealthTimeout = checkHealthTimeout;
    }

    private void copyServiceConfig(ServiceConfig<?> dest) {
        if (null != this.interfaceClass) {
            dest.setInterface(this.interfaceClass);
        }
        if (StringHelper.isNotEmpty((String)this.path)) {
            dest.setPath(this.path);
        }
        if (null != this.provider) {
            dest.setProvider(this.provider);
        }
        if (null != this.accesslog) {
            dest.setAccesslog(this.accesslog);
        }
        if (null != this.actives) {
            dest.setActives(this.actives);
        }
        if (null != this.application) {
            dest.setApplication(this.application);
        }
        if (null != this.async) {
            dest.setAsync(this.async);
        }
        if (StringHelper.isNotEmpty((String)this.cache)) {
            dest.setCache(this.cache);
        }
        if (null != this.getCallbacks()) {
            dest.setCallbacks(this.getCallbacks());
        }
        if (StringHelper.isNotEmpty((String)this.cluster)) {
            dest.setCluster(this.cluster);
        }
        if (null != this.connections) {
            dest.setConnections(this.connections);
        }
        if (null != this.delay) {
            dest.setDelay(this.delay);
        }
        if (null != this.deprecated) {
            dest.setDeprecated(this.deprecated);
        }
        if (StringHelper.isNotEmpty((String)this.document)) {
            dest.setDocument(this.document);
        }
        if (null != this.dynamic) {
            dest.setDynamic(this.dynamic);
        }
        if (null != this.getExecutes()) {
            dest.setExecutes(this.getExecutes());
        }
        if (StringHelper.isNotEmpty((String)this.filter)) {
            dest.setFilter(this.filter);
        }
        if (StringHelper.isNotEmpty((String)this.group)) {
            dest.setGroup(this.group);
        }
        if (StringHelper.isNotEmpty((String)this.id)) {
            dest.setId(this.id);
        }
        if (StringHelper.isNotEmpty((String)this.layer)) {
            dest.setLayer(this.layer);
        }
        if (StringHelper.isNotEmpty((String)this.listener)) {
            dest.setListener(this.listener);
        }
        if (StringHelper.isNotEmpty((String)this.loadbalance)) {
            dest.setLoadbalance(this.loadbalance);
        }
        if (StringHelper.isNotEmpty((String)this.merger)) {
            dest.setMerger(this.merger);
        }
        if (StringHelper.isNotEmpty((String)this.mock)) {
            dest.setMock(this.mock);
        }
        if (null != this.module) {
            dest.setModule(this.module);
        }
        if (null != this.monitor) {
            dest.setMonitor(this.monitor);
        }
        if (StringHelper.isNotEmpty((String)this.onconnect)) {
            dest.setOnconnect(this.onconnect);
        }
        if (StringHelper.isNotEmpty((String)this.ondisconnect)) {
            dest.setOndisconnect(this.ondisconnect);
        }
        if (StringHelper.isNotEmpty((String)this.owner)) {
            dest.setOwner(this.owner);
        }
        if (null != this.parameters) {
            dest.setParameters(this.parameters);
        }
        if (StringHelper.isNotEmpty((String)this.proxy)) {
            dest.setProxy(this.proxy);
        }
        if (null != this.isRegister()) {
            dest.setRegister(this.isRegister());
        }
        if (null != this.registries && this.registries.size() > 0) {
            dest.setRegistries(this.registries);
        }
        if (null != this.retries) {
            dest.setRetries(this.retries);
        }
        if (StringHelper.isNotEmpty((String)this.getScope())) {
            dest.setScope(this.getScope());
        }
        if (null != this.sent) {
            dest.setSent(this.sent);
        }
        if (StringHelper.isNotEmpty((String)this.stub)) {
            dest.setStub(this.stub);
        }
        if (null != this.timeout) {
            dest.setTimeout(this.timeout);
        }
        if (StringHelper.isNotEmpty((String)this.token)) {
            dest.setToken(this.token);
        }
        if (StringHelper.isNotEmpty((String)this.validation)) {
            dest.setValidation(this.validation);
        }
        if (StringHelper.isNotEmpty((String)this.version)) {
            dest.setVersion(this.version);
        }
        if (null != this.weight) {
            dest.setWeight(this.weight);
        }
        if (null != this.protocols) {
            dest.setProtocols(this.protocols);
        }
    }
}

