/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.dubbo;

import eventcenter.api.EventCenter;
import eventcenter.api.support.DefaultEventCenter;
import eventcenter.builder.SubscriberConfig;
import eventcenter.builder.dubbo.DubboConfig;
import eventcenter.builder.dubbo.DubboConfigContext;
import eventcenter.builder.dubbo.EventSubscriberServiceConfig;
import eventcenter.remote.SubscriberGroup;
import eventcenter.remote.subscriber.EventSubscriber;

public class DubboSubscriberConfig
extends SubscriberConfig {
    private static final long serialVersionUID = -3578154819486724152L;
    protected EventSubscriberServiceConfig serviceConfig;
    protected EventSubscriber subscriber = new EventSubscriber();

    @Override
    public eventcenter.remote.EventSubscriber load(DefaultEventCenter eventCenter) {
        if (null == this.serviceConfig) {
            throw new IllegalArgumentException("please set serviceConfig");
        }
        DubboConfig dubboConfig = DubboConfigContext.getInstance().getDubboConfig();
        if (null != dubboConfig.getApplicationConfig()) {
            this.serviceConfig.setApplication(dubboConfig.getApplicationConfig());
        }
        if (null != dubboConfig.getProtocolConfig()) {
            this.serviceConfig.setProtocol(dubboConfig.getProtocolConfig());
        }
        if (null != dubboConfig.getRegistryConfig()) {
            this.serviceConfig.setRegistry(dubboConfig.getRegistryConfig());
        }
        String groupName = this.serviceConfig.getGroup() != null ? this.serviceConfig.getGroup() : DubboConfigContext.getInstance().getDubboConfig().getGroupName();
        boolean loadSubscriber = false;
        if (null != groupName && this.getSubscriberGroups().size() > 0) {
            for (SubscriberGroup subscriberGroup : this.getSubscriberGroups()) {
                subscriberGroup.setGroupName(groupName);
            }
            loadSubscriber = true;
            this.subscriber.setSubscriberGroups(this.getSubscriberGroups());
        }
        if (null != groupName) {
            this.serviceConfig.setGroup(groupName);
        }
        this.subscriber.setEventCenter((EventCenter)eventCenter);
        this.serviceConfig.load(this.subscriber, loadSubscriber);
        DubboConfigContext.getInstance().setLocalSubscriberId(this.subscriber.getId());
        return this.subscriber;
    }

    public EventSubscriberServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(EventSubscriberServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public EventSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(EventSubscriber subscriber) {
        this.subscriber = subscriber;
    }
}

