/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.dubbo;

import eventcenter.builder.PublisherGroupBuilder;
import eventcenter.builder.dubbo.DubboConfig;
import eventcenter.builder.dubbo.DubboConfigContext;
import eventcenter.builder.dubbo.EventTransmissionReferenceConfig;
import eventcenter.remote.EventTransmission;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.utils.StringHelper;

public class DubboPublisherGroupBuilder
extends PublisherGroupBuilder {
    protected EventTransmissionReferenceConfig refConfig;
    protected volatile boolean isLoad = false;

    public DubboPublisherGroupBuilder eventTransmission(EventTransmissionReferenceConfig refConfig) {
        this.refConfig = refConfig;
        return this;
    }

    public EventTransmissionReferenceConfig getRefConfig() {
        return this.refConfig;
    }

    DubboPublisherGroupBuilder load(DubboConfig dubboConfig) {
        if (null == this.refConfig) {
            throw new IllegalArgumentException("please set eventTransmission");
        }
        if (dubboConfig.getApplicationConfig() != null) {
            this.refConfig.setApplication(dubboConfig.getApplicationConfig());
        }
        if (dubboConfig.getRegistryConfig() != null) {
            this.refConfig.setRegistry(dubboConfig.getRegistryConfig());
        }
        this.refConfig.setCheck(false);
        if (this.refConfig.getId() == null) {
            this.refConfig.setId(this.createRefId());
        }
        if (this.groupName == null) {
            this.groupName(dubboConfig.getGroupName());
        }
        if (this.refConfig.getGroup() == null) {
            this.refConfig.setGroup(this.groupName);
        }
        if (StringHelper.isEmpty((String)this.name)) {
            this.name(this.buildName());
        }
        this.refConfig.load();
        this.isLoad = true;
        return this;
    }

    String buildName() {
        return this.groupName + "_" + this.refConfig.getVersion();
    }

    String createRefId() {
        return "eventTransmission" + System.currentTimeMillis();
    }

    @Override
    public PublisherGroup build() {
        if (!this.isLoad) {
            throw new IllegalArgumentException("please load first");
        }
        this.checkAndRefillRefConfig();
        this.eventTransmission = (EventTransmission)this.refConfig.get();
        return super.build();
    }

    void checkAndRefillRefConfig() {
        DubboConfig dubboConfig = DubboConfigContext.getInstance().getDubboConfig();
        if (this.refConfig.getApplication() == null) {
            this.refConfig.setApplication(dubboConfig.applicationConfig);
        }
        if (this.refConfig.getRegistry() == null) {
            this.refConfig.setRegistry(dubboConfig.getRegistryConfig());
        }
    }
}

