/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.dubbo;

import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.registry.RegistryService;
import eventcenter.builder.PublisherConfig;
import eventcenter.builder.dubbo.DubboConfig;
import eventcenter.builder.dubbo.DubboConfigContext;
import eventcenter.remote.dubbo.publisher.DubboRegistryEventPublisher;
import eventcenter.remote.publisher.PublishEventCenter;
import eventcenter.remote.utils.StringHelper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DubboPublisherConfig
extends PublisherConfig {
    private static final long serialVersionUID = -4294792096771074963L;
    private Boolean subscriberAutowired;
    private String groupName;
    private Boolean copySendUnderSameVersion;
    private Boolean devMode;
    private Long expiryOffline;

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Boolean getCopySendUnderSameVersion() {
        return this.copySendUnderSameVersion;
    }

    public void setCopySendUnderSameVersion(Boolean copySendUnderSameVersion) {
        this.copySendUnderSameVersion = copySendUnderSameVersion;
    }

    public Boolean getDevMode() {
        return this.devMode;
    }

    public void setDevMode(Boolean devMode) {
        this.devMode = devMode;
    }

    public Long getExpiryOffline() {
        return this.expiryOffline;
    }

    public void setExpiryOffline(Long expiryOffline) {
        this.expiryOffline = expiryOffline;
    }

    public Boolean getSubscriberAutowired() {
        return this.subscriberAutowired;
    }

    public void setSubscriberAutowired(Boolean subscriberAutowired) {
        this.subscriberAutowired = subscriberAutowired;
    }

    @Override
    public PublishEventCenter load(PublishEventCenter eventCenter) {
        if (null == this.getSubscriberAutowired() || !this.getSubscriberAutowired().booleanValue()) {
            return super.load(eventCenter);
        }
        DubboConfig dubboConfig = DubboConfigContext.getInstance().getDubboConfig();
        if (null == dubboConfig.getRegistryConfig()) {
            throw new IllegalArgumentException("please set registryConfig when subscriberAutowired is open");
        }
        if (StringHelper.isEmpty((String)dubboConfig.getRegistryConfig().getAddress())) {
            throw new IllegalArgumentException("please set address of registryConfig");
        }
        DubboRegistryEventPublisher eventPublisher = new DubboRegistryEventPublisher();
        eventPublisher.setDubboGroup(null != this.groupName ? this.groupName : dubboConfig.getGroupName());
        if (null != this.copySendUnderSameVersion) {
            eventPublisher.setCopySendUnderSameVersion(this.copySendUnderSameVersion.booleanValue());
        }
        if (null != this.devMode) {
            eventPublisher.setDevMode(this.devMode.booleanValue());
        }
        if (null != this.expiryOffline) {
            eventPublisher.setExpiryOffline(this.expiryOffline.intValue());
        }
        if (null != dubboConfig.getApplicationContext()) {
            eventPublisher.setApplicationContext(dubboConfig.getApplicationContext());
        }
        eventPublisher.copy2RegistryConfig(dubboConfig.getRegistryConfig());
        if (null != DubboConfigContext.getInstance().getLocalSubscriberId()) {
            eventPublisher.setLocalSubscriberId(DubboConfigContext.getInstance().getLocalSubscriberId());
        }
        this.initRegistryService(eventPublisher, dubboConfig);
        this.eventPublisher = eventPublisher;
        return super.load(eventCenter);
    }

    private void initRegistryService(DubboRegistryEventPublisher eventPublisher, DubboConfig dubboConfig) {
        if (dubboConfig.getApplicationContext() != null) {
            try {
                dubboConfig.getApplicationContext().getBean(RegistryService.class);
                return;
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        ReferenceConfig config = new ReferenceConfig();
        config.setApplication(dubboConfig.getApplicationConfig());
        config.setRegistry(dubboConfig.getRegistryConfig());
        config.setInterface(RegistryService.class);
        config.setId("registryService" + System.currentTimeMillis());
        eventPublisher.setRegistryService((RegistryService)config.get());
    }
}

