/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.builder.dubbo.DubboConfig;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class DubboConfigContext {
    private static DubboConfigContext self;
    private static Object lock;
    protected DubboConfig dubboConfig = new DubboConfig();
    protected String localSubscriberId;
    protected volatile boolean loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DubboConfigContext getInstance() {
        if (null == self) {
            Object object = lock;
            synchronized (object) {
                if (null == self) {
                    self = new DubboConfigContext();
                }
            }
        }
        return self;
    }

    public DubboConfig getDubboConfig() {
        return this.dubboConfig;
    }

    public DubboConfigContext load(ApplicationContext context) {
        if (this.loaded) {
            return this;
        }
        if (null == this.dubboConfig.getApplicationConfig()) {
            this.dubboConfig.setApplicationConfig(this.getBean(context, ApplicationConfig.class));
        }
        if (null == this.dubboConfig.getProtocolConfig()) {
            this.dubboConfig.setProtocolConfig(this.getBean(context, ProtocolConfig.class));
        }
        if (null == this.dubboConfig.getRegistryConfig()) {
            this.dubboConfig.setRegistryConfig(this.getBean(context, RegistryConfig.class));
        }
        this.dubboConfig.setApplicationContext(context);
        this.loaded = true;
        return this;
    }

    private <T> T getBean(ApplicationContext context, Class<T> type) {
        try {
            return (T)context.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public DubboConfigContext applicationConfig(ApplicationConfig config) {
        this.dubboConfig.setApplicationConfig(config);
        return this;
    }

    public DubboConfigContext applicationName(String name) {
        if (null == this.dubboConfig.getApplicationConfig()) {
            this.dubboConfig.setApplicationConfig(new ApplicationConfig());
        }
        this.dubboConfig.getApplicationConfig().setName(name);
        return this;
    }

    public DubboConfigContext applicationOwner(String owner) {
        if (null == this.dubboConfig.getApplicationConfig()) {
            this.dubboConfig.setApplicationConfig(new ApplicationConfig());
        }
        this.dubboConfig.getApplicationConfig().setOwner(owner);
        return this;
    }

    public DubboConfigContext protocolConfig(ProtocolConfig config) {
        this.dubboConfig.setProtocolConfig(config);
        return this;
    }

    public DubboConfigContext protocolName(String name) {
        if (null == this.dubboConfig.getProtocolConfig()) {
            this.dubboConfig.setProtocolConfig(new ProtocolConfig());
        }
        this.dubboConfig.getProtocolConfig().setName(name);
        return this;
    }

    public DubboConfigContext protocolHost(String host) {
        if (null == this.dubboConfig.getProtocolConfig()) {
            this.dubboConfig.setProtocolConfig(new ProtocolConfig());
        }
        this.dubboConfig.getProtocolConfig().setHost(host);
        return this;
    }

    public DubboConfigContext protocolPort(Integer port) {
        if (null == this.dubboConfig.getProtocolConfig()) {
            this.dubboConfig.setProtocolConfig(new ProtocolConfig());
        }
        this.dubboConfig.getProtocolConfig().setPort(port);
        return this;
    }

    public DubboConfigContext registryConfig(RegistryConfig config) {
        this.dubboConfig.setRegistryConfig(config);
        return this;
    }

    public DubboConfigContext registryProtocol(String protocol) {
        if (null == this.dubboConfig.getRegistryConfig()) {
            this.dubboConfig.setRegistryConfig(new RegistryConfig());
        }
        this.dubboConfig.getRegistryConfig().setProtocol(protocol);
        return this;
    }

    public DubboConfigContext registryAddress(String address) {
        if (null == this.dubboConfig.getRegistryConfig()) {
            this.dubboConfig.setRegistryConfig(new RegistryConfig());
        }
        this.dubboConfig.getRegistryConfig().setAddress(address);
        return this;
    }

    public DubboConfigContext registryUsername(String username) {
        if (null == this.dubboConfig.getRegistryConfig()) {
            this.dubboConfig.setRegistryConfig(new RegistryConfig());
        }
        this.dubboConfig.getRegistryConfig().setUsername(username);
        return this;
    }

    public DubboConfigContext registryPassword(String password) {
        if (null == this.dubboConfig.getRegistryConfig()) {
            this.dubboConfig.setRegistryConfig(new RegistryConfig());
        }
        this.dubboConfig.getRegistryConfig().setPassword(password);
        return this;
    }

    public DubboConfigContext groupName(String groupName) {
        this.dubboConfig.setGroupName(groupName);
        return this;
    }

    public String getLocalSubscriberId() {
        return this.localSubscriberId;
    }

    void setLocalSubscriberId(String localSubscriberId) {
        this.localSubscriberId = localSubscriberId;
    }

    static {
        lock = new Object();
    }
}

