/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder;

import eventcenter.remote.EventTransmission;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.utils.StringHelper;

public class PublisherGroupBuilder {
    protected String remoteEvents;
    protected String groupName;
    protected EventTransmission eventTransmission;
    protected String name;

    public PublisherGroupBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PublisherGroupBuilder remoteEvents(String remoteEvents) {
        this.remoteEvents = remoteEvents;
        return this;
    }

    public PublisherGroupBuilder groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public PublisherGroupBuilder eventTransmission(EventTransmission eventTransmission) {
        this.eventTransmission = eventTransmission;
        return this;
    }

    public PublisherGroup build() {
        if (StringHelper.isEmpty((String)this.name)) {
            throw new IllegalArgumentException("please set name for publisher group");
        }
        PublisherGroup group = new PublisherGroup(this.name, this.eventTransmission);
        group.setGroupName(this.groupName);
        group.setRemoteEvents(this.remoteEvents);
        return group;
    }
}

