/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder;

import eventcenter.builder.PublisherGroupBuilder;
import eventcenter.remote.EventPublisher;
import eventcenter.remote.publisher.LocalPublisherGroup;
import eventcenter.remote.publisher.PublishEventCenter;
import eventcenter.remote.publisher.PublisherGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PublisherConfig
implements Serializable {
    private static final long serialVersionUID = 2520698005690310859L;
    protected List<PublisherGroupBuilder> groupBuilders;
    protected LocalPublisherGroup localPublisherGroup;
    protected EventPublisher eventPublisher;
    protected Boolean asyncFireRemote;

    protected PublisherConfig() {
    }

    public List<PublisherGroupBuilder> getGroupBuilders() {
        if (null == this.groupBuilders) {
            this.groupBuilders = new ArrayList<PublisherGroupBuilder>();
        }
        return this.groupBuilders;
    }

    public void setGroupBuilders(List<PublisherGroupBuilder> groupBuilders) {
        this.groupBuilders = groupBuilders;
    }

    public LocalPublisherGroup getLocalPublisherGroup() {
        return this.localPublisherGroup;
    }

    public void setLocalPublisherGroup(LocalPublisherGroup localPublisherGroup) {
        this.localPublisherGroup = localPublisherGroup;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Boolean getAsyncFireRemote() {
        return this.asyncFireRemote;
    }

    public void setAsyncFireRemote(Boolean asyncFireRemote) {
        this.asyncFireRemote = asyncFireRemote;
    }

    public PublishEventCenter load(PublishEventCenter eventCenter) {
        List<PublisherGroupBuilder> groupBuilders;
        if (null != this.asyncFireRemote) {
            eventCenter.setAsyncFireRemote(this.asyncFireRemote.booleanValue());
        }
        if (null != this.localPublisherGroup) {
            eventCenter.getPublisherGroups().add(this.localPublisherGroup);
        }
        if (null != this.getEventPublisher()) {
            eventCenter.setEventPublisher(this.getEventPublisher());
        }
        if ((groupBuilders = this.getGroupBuilders()).size() > 0) {
            ArrayList<PublisherGroup> publisherGroups = new ArrayList<PublisherGroup>(groupBuilders.size());
            for (PublisherGroupBuilder publisherGroupBuilder : this.getGroupBuilders()) {
                publisherGroups.add(publisherGroupBuilder.build());
            }
            eventCenter.getEventPublisher().publish(publisherGroups);
        }
        return eventCenter;
    }
}

