/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder;

import eventcenter.api.AbstractEventCenter;
import eventcenter.api.support.DefaultEventCenter;
import eventcenter.builder.dubbo.DubboConfigContext;
import eventcenter.monitor.AbstractControlMonitor;
import eventcenter.monitor.ControlMonitor;
import eventcenter.monitor.client.filter.ListenerExecutedFilter;
import eventcenter.monitor.client.filter.RemoteFilter;
import eventcenter.remote.publisher.PublishEventCenter;
import java.io.Serializable;

public abstract class MonitorConfig
implements Serializable {
    private static final long serialVersionUID = 794004761466469150L;
    protected AbstractControlMonitor monitor;
    protected Boolean saveEventData;
    protected Long heartbeatInterval;
    protected String nodeName;
    protected boolean loadFilters = true;
    protected volatile boolean loaded = false;

    public Boolean getSaveEventData() {
        return this.saveEventData;
    }

    public void setSaveEventData(Boolean saveEventData) {
        this.saveEventData = saveEventData;
    }

    public Long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    protected abstract AbstractControlMonitor createControlMonitor(DefaultEventCenter var1, boolean var2);

    public boolean isLoadFilters() {
        return this.loadFilters;
    }

    public void setLoadFilters(boolean loadFilters) {
        this.loadFilters = loadFilters;
    }

    public AbstractControlMonitor load(DefaultEventCenter eventCenter, boolean subscriber) {
        if (this.loaded) {
            return this.monitor;
        }
        this.monitor = this.initControlMonitor(this.createControlMonitor(eventCenter, subscriber), eventCenter);
        if (this.loadFilters) {
            this.loadFilters(this.monitor, eventCenter, subscriber);
            this.monitor.startup();
        }
        this.loaded = true;
        return this.monitor;
    }

    protected void loadFilters(AbstractControlMonitor controlMonitor, DefaultEventCenter eventCenter, boolean subscriber) {
        ListenerExecutedFilter listenerExecutedFilter = new ListenerExecutedFilter();
        listenerExecutedFilter.setControlMonitor((ControlMonitor)controlMonitor);
        eventCenter.getEcConfig().getGlobalFilters().add(listenerExecutedFilter);
        if (eventCenter instanceof PublishEventCenter || subscriber) {
            RemoteFilter remoteFilter = new RemoteFilter();
            remoteFilter.setControlMonitor((ControlMonitor)controlMonitor);
            eventCenter.getEcConfig().getModuleFilters().add(remoteFilter);
        }
    }

    protected AbstractControlMonitor initControlMonitor(AbstractControlMonitor monitor, DefaultEventCenter eventCenter) {
        monitor.setEventCenter((AbstractEventCenter)eventCenter);
        monitor.setGroup(DubboConfigContext.getInstance().getDubboConfig().getGroupName());
        if (this.heartbeatInterval != null) {
            monitor.setHeartbeatInterval(this.heartbeatInterval.longValue());
        }
        if (null != this.saveEventData) {
            monitor.setSaveEventData(this.saveEventData.booleanValue());
        }
        monitor.setNodeName(this.nodeName);
        return monitor;
    }
}

