/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder;

import eventcenter.api.CommonEventListenerConfig;
import eventcenter.api.EventCenterConfig;
import eventcenter.api.EventFireFilter;
import eventcenter.api.EventListener;
import eventcenter.api.ListenerFilter;
import eventcenter.api.aggregator.AggregatorContainer;
import eventcenter.api.annotation.ListenerBind;
import eventcenter.api.async.QueueEventContainerFactory;
import eventcenter.api.async.simple.SimpleQueueEventContainerFactory;
import eventcenter.api.support.DefaultEventCenter;
import eventcenter.builder.AggregatorContainerBuilder;
import eventcenter.builder.MonitorConfig;
import eventcenter.builder.PublisherConfig;
import eventcenter.builder.SubscriberConfig;
import eventcenter.builder.monitor.mysql.MysqlMonitorConfig;
import eventcenter.remote.publisher.PublishEventCenter;
import eventcenter.remote.saf.SAFPublishEventCenter;
import eventcenter.remote.saf.StoreAndForwardPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class EventCenterBuilder {
    protected EventCenterConfig eventCenterConfig;
    protected List<EventFireFilter> eventFireFilters;
    protected AggregatorContainer aggregatorContainer;
    protected PublisherConfig publisherConfig;
    protected SubscriberConfig subscriberConfig;
    protected MonitorConfig monitorConfig;
    protected StoreAndForwardPolicy safPolicy;
    protected CommonEventListenerConfig commonEventListenerConfig;
    protected ApplicationContext applicationContext;

    EventCenterConfig getEventCenterConfig() {
        if (null == this.eventCenterConfig) {
            this.eventCenterConfig = new EventCenterConfig();
        }
        return this.eventCenterConfig;
    }

    CommonEventListenerConfig getCommonEventListenerConfig() {
        if (null == this.commonEventListenerConfig) {
            this.commonEventListenerConfig = new CommonEventListenerConfig();
        }
        return this.commonEventListenerConfig;
    }

    public List<EventFireFilter> getEventFireFilters() {
        if (null == this.eventFireFilters) {
            this.eventFireFilters = new ArrayList<EventFireFilter>();
        }
        return this.eventFireFilters;
    }

    public EventCenterBuilder applicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public EventCenterBuilder openLoggerMdc(Boolean openLoggerMdc) {
        this.getEventCenterConfig().setOpenLoggerMdc(openLoggerMdc.booleanValue());
        return this;
    }

    public EventCenterBuilder loggerMdcField(String loggerMdcField) {
        this.getEventCenterConfig().setLoggerMdcField(loggerMdcField);
        return this;
    }

    public EventCenterBuilder simpleQueueContainer(Integer corePoolSize) {
        return this.simpleQueueContainer(corePoolSize, null, null);
    }

    public EventCenterBuilder simpleQueueContainer(Integer corePoolSize, Integer queueCapacity) {
        return this.simpleQueueContainer(corePoolSize, queueCapacity, null);
    }

    public EventCenterBuilder simpleQueueContainer(Integer corePoolSize, Integer queueCapacity, Integer maximumPoolSize) {
        SimpleQueueEventContainerFactory factory = new SimpleQueueEventContainerFactory();
        factory.setCorePoolSize(corePoolSize);
        factory.setQueueCapacity(queueCapacity);
        factory.setMaximumPoolSize(maximumPoolSize);
        return this.queueContainerFactory((QueueEventContainerFactory)factory);
    }

    public EventCenterBuilder queueContainerFactory(QueueEventContainerFactory factory) {
        this.getEventCenterConfig().setQueueEventContainerFactory(factory);
        return this;
    }

    public EventCenterBuilder addListenerFilter(String eventName, ListenerFilter listenerFilter) {
        this.getEventCenterConfig().addFilter(eventName, listenerFilter);
        return this;
    }

    public EventCenterBuilder addGlobleFilter(ListenerFilter listenerFilter) {
        this.getEventCenterConfig().getGlobalFilters().add(listenerFilter);
        return this;
    }

    public EventCenterBuilder addEventFireFilter(EventFireFilter filter) {
        this.getEventFireFilters().add(filter);
        return this;
    }

    public EventCenterBuilder addEventListener(String eventName, EventListener listener) {
        ArrayList<EventListener> listeners = (ArrayList<EventListener>)this.getCommonEventListenerConfig().getListeners().get(eventName);
        if (null == listeners) {
            listeners = new ArrayList<EventListener>();
            this.getCommonEventListenerConfig().getListeners().put(eventName, listeners);
        }
        listeners.add(listener);
        return this;
    }

    public EventCenterBuilder addEventListener(EventListener listener) {
        String[] eventNames;
        ListenerBind bind = listener.getClass().getAnnotation(ListenerBind.class);
        if (null == bind) {
            throw new IllegalArgumentException("please input eventName or tag ListenerBind on EventListener");
        }
        for (String eventName : eventNames = bind.value().split(",")) {
            this.addEventListener(eventName.trim(), listener);
        }
        return this;
    }

    public EventCenterBuilder addEventListeners(List<EventListener> listeners) {
        for (EventListener listener : listeners) {
            this.addEventListener(listener);
        }
        return this;
    }

    public EventCenterBuilder aggregatorContainer(AggregatorContainer container) {
        this.aggregatorContainer = container;
        return this;
    }

    public EventCenterBuilder simpleAggregatorContainer(Integer corePoolSize, Integer maximumPoolSize) {
        this.aggregatorContainer = new AggregatorContainerBuilder().simpleAggregatorContainer(corePoolSize, maximumPoolSize).build();
        return this;
    }

    public EventCenterBuilder simpleAggregatorContainer(ThreadPoolExecutor executor) {
        this.aggregatorContainer = new AggregatorContainerBuilder().simpleAggregatorContainer(executor).build();
        return this;
    }

    public EventCenterBuilder safPolicy(StoreAndForwardPolicy policy) {
        this.safPolicy = policy;
        return this;
    }

    public EventCenterBuilder publisher(PublisherConfig config) {
        this.publisherConfig = config;
        return this;
    }

    public EventCenterBuilder subscriber(SubscriberConfig config) {
        this.subscriberConfig = config;
        return this;
    }

    public EventCenterBuilder monitor(MonitorConfig config) {
        this.monitorConfig = config;
        return this;
    }

    public DefaultEventCenter build() throws Exception {
        DefaultEventCenter eventCenter;
        if (null == this.publisherConfig) {
            eventCenter = new DefaultEventCenter();
        } else if (null == this.safPolicy) {
            eventCenter = new PublishEventCenter();
        } else {
            eventCenter = new SAFPublishEventCenter();
            ((SAFPublishEventCenter)eventCenter).setSafPolicy(this.safPolicy);
        }
        if (null != this.applicationContext) {
            eventCenter.setApplicationContext(this.applicationContext);
        }
        this.getEventCenterConfig().getModuleFilters().addAll(this.getEventFireFilters());
        eventCenter.setEcConfig(this.getEventCenterConfig());
        eventCenter.setAggregatorContainer(this.aggregatorContainer);
        if (null != this.commonEventListenerConfig) {
            eventCenter.getEcConfig().setEventListenerConfig(this.commonEventListenerConfig);
        }
        if (null != this.subscriberConfig) {
            this.subscriberConfig.load(eventCenter);
        }
        if (null != this.publisherConfig) {
            this.publisherConfig.load((PublishEventCenter)eventCenter);
        }
        if (null != this.monitorConfig) {
            this.initMonitorConfig();
            this.monitorConfig.load(eventCenter, this.subscriberConfig != null);
        }
        return eventCenter;
    }

    void initMonitorConfig() {
        if (null == this.applicationContext) {
            return;
        }
        if (!(this.monitorConfig instanceof MysqlMonitorConfig)) {
            return;
        }
        MysqlMonitorConfig mysqlMonitorConfig = (MysqlMonitorConfig)this.monitorConfig;
        if (!StringUtils.hasText((String)mysqlMonitorConfig.getDataSourceBeanId())) {
            return;
        }
        mysqlMonitorConfig.setDataSource((DataSource)this.applicationContext.getBean(mysqlMonitorConfig.getDataSourceBeanId(), DataSource.class));
    }
}

