/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder;

import eventcenter.api.aggregator.AggregatorContainer;
import eventcenter.api.aggregator.simple.AggregatorThreadPoolInfo;
import eventcenter.api.aggregator.simple.SimpleAggregatorContainer;
import eventcenter.api.aggregator.simple.SimpleAggregatorMultiContainer;
import eventcenter.remote.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class AggregatorContainerBuilder {
    protected Integer corePoolSize;
    protected Integer maximumPoolSize;
    protected ThreadPoolExecutor executor;
    private List<AggregatorThreadPoolInfo> infos;

    public List<AggregatorThreadPoolInfo> getInfos() {
        if (null == this.infos) {
            this.infos = new ArrayList<AggregatorThreadPoolInfo>();
        }
        return this.infos;
    }

    public void setInfos(List<AggregatorThreadPoolInfo> infos) {
        this.infos = infos;
    }

    public AggregatorContainerBuilder simpleAggregatorContainer(Integer corePoolSize, Integer maximumPoolSize) {
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public AggregatorContainerBuilder simpleAggregatorContainer(ThreadPoolExecutor executor) {
        this.executor = executor;
        return this;
    }

    public AggregatorContainerBuilder threadPoolInfo(String eventNames, Integer corePoolSize, Integer maximumPoolSize) {
        if (StringHelper.isEmpty((String)eventNames)) {
            throw new IllegalArgumentException("please set eventNames");
        }
        AggregatorThreadPoolInfo info = new AggregatorThreadPoolInfo();
        info.setEventNames(eventNames);
        info.setCorePoolSize(corePoolSize);
        info.setMaximumPoolSize(maximumPoolSize);
        this.getInfos().add(info);
        return this;
    }

    public AggregatorContainer build() {
        if (this.getInfos().size() > 0) {
            SimpleAggregatorMultiContainer container = null != this.executor ? new SimpleAggregatorMultiContainer(this.executor) : (this.corePoolSize != null ? new SimpleAggregatorMultiContainer(this.corePoolSize.intValue(), this.maximumPoolSize.intValue()) : new SimpleAggregatorMultiContainer());
            container.setThreadPoolInfos(this.getInfos());
            return container;
        }
        SimpleAggregatorContainer container = null != this.executor ? new SimpleAggregatorContainer(this.executor) : (this.corePoolSize != null ? new SimpleAggregatorContainer(this.corePoolSize.intValue(), this.maximumPoolSize.intValue()) : new SimpleAggregatorContainer());
        return container;
    }
}

