package eventcenter.builder.spring;

import eventcenter.api.support.DefaultEventCenter;
import eventcenter.builder.EventCenterBuilder;
import eventcenter.builder.dubbo.DubboConfigContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 *
 * @author liumingjian
 * @date 2017/9/27
 */
public class EventCenterFactoryBean extends AbstractFactoryBean<DefaultEventCenter> implements ApplicationContextAware {

    private EventCenterBuilder builder;

    private ApplicationContext applicationContext;

    public EventCenterBuilder getBuilder() {
        return builder;
    }

    public void setBuilder(EventCenterBuilder builder) {
        this.builder = builder;
    }

    /**
     * 初始化
     */
    private void init(){
        this.builder.applicationContext(this.applicationContext);
        DubboConfigContext.getInstance().load(this.applicationContext);
    }

    @Override
    public Class<?> getObjectType() {
        return DefaultEventCenter.class;
    }

    @Override
    protected DefaultEventCenter createInstance() throws Exception {
        init();
        return this.builder.build();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void startup() throws Exception {
        this.getObject().startup();
    }

    public void shutdown() throws Exception {
        this.getObject().shutdown();
    }
}
