/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2.rooms;

import io.evanwong.oss.hipchat.v2.commons.NoContent;
import io.evanwong.oss.hipchat.v2.commons.PutRequest;
import io.evanwong.oss.hipchat.v2.rooms.Privacy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;

public class UpdateRoomRequest
extends PutRequest<NoContent> {
    private String roomIdOrName;
    private String name;
    private Privacy privacy;
    private boolean archived;
    private boolean guestAccessible;
    private String topic;
    private String ownerIdOrEmail;

    public UpdateRoomRequest(String roomIdOrName, String accessToken, HttpClient httpClient, ExecutorService executorService) {
        super(accessToken, httpClient, executorService);
        this.roomIdOrName = roomIdOrName;
    }

    public String getRoomIdOrName() {
        return this.roomIdOrName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    public boolean getArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean getGuestAccessible() {
        return this.guestAccessible;
    }

    public void setGuestAccessible(boolean guestAccessible) {
        this.guestAccessible = guestAccessible;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getOwnerIdOrEmail() {
        return this.ownerIdOrEmail;
    }

    public void setOwnerIdOrEmail(String ownerIdOrEmail) {
        this.ownerIdOrEmail = ownerIdOrEmail;
    }

    @Override
    protected String getPath() {
        return "/room/" + this.roomIdOrName;
    }

    @Override
    protected Map<String, Object> toQueryMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("topic", this.topic);
        params.put("is_guest_accessible", this.guestAccessible);
        params.put("name", this.name);
        params.put("is_archived", this.archived);
        params.put("privacy", this.privacy.getValue());
        params.put("owner", Collections.singletonMap("id", this.ownerIdOrEmail));
        return params;
    }
}

