/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2.rooms;

import io.evanwong.oss.hipchat.v2.commons.RequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.MessageColor;
import io.evanwong.oss.hipchat.v2.rooms.MessageFormat;
import io.evanwong.oss.hipchat.v2.rooms.SendRoomNotificationRequest;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;

public class SendRoomNotificationRequestBuilder
extends RequestBuilder<SendRoomNotificationRequest> {
    private String idOrName;
    private MessageColor color;
    private String message;
    private Boolean notify;
    private MessageFormat messageFormat;

    public SendRoomNotificationRequestBuilder(String idOrName, String message, String accessToken, HttpClient httpClient, ExecutorService executorService) {
        super(accessToken, httpClient, executorService);
        this.idOrName = idOrName;
        this.message = message;
    }

    public SendRoomNotificationRequestBuilder setColor(MessageColor color) {
        this.color = color;
        return this;
    }

    public SendRoomNotificationRequestBuilder setNotify(Boolean notify) {
        this.notify = notify;
        return this;
    }

    public SendRoomNotificationRequestBuilder setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    @Override
    public SendRoomNotificationRequest build() {
        if (this.message == null) {
            throw new IllegalArgumentException("message is required.");
        }
        if (this.idOrName == null) {
            throw new IllegalArgumentException("idOrName is required.");
        }
        return new SendRoomNotificationRequest(this.idOrName, this.color, this.message, this.notify, this.messageFormat, this.accessToken, this.httpClient, this.executorService);
    }
}

