/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2.rooms;

import io.evanwong.oss.hipchat.v2.commons.NoContent;
import io.evanwong.oss.hipchat.v2.commons.PostRequest;
import io.evanwong.oss.hipchat.v2.rooms.MessageColor;
import io.evanwong.oss.hipchat.v2.rooms.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;

public class SendRoomNotificationRequest
extends PostRequest<NoContent> {
    private String idOrName;
    private MessageColor color;
    private String message;
    private Boolean notify;
    private MessageFormat messageFormat;

    SendRoomNotificationRequest(String idOrName, MessageColor color, String message, Boolean notify, MessageFormat messageFormat, String accessToken, HttpClient httpClient, ExecutorService executorService) {
        super(accessToken, httpClient, executorService);
        this.idOrName = idOrName;
        this.color = color;
        this.message = message;
        this.notify = notify;
        this.messageFormat = messageFormat;
    }

    public String getIdOrName() {
        return this.idOrName;
    }

    public MessageColor getColor() {
        return this.color;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getNotify() {
        return this.notify;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    protected String getPath() {
        return "/room/" + this.idOrName + "/notification";
    }

    @Override
    protected Map<String, Object> toQueryMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.color != null) {
            params.put("color", this.color.name().toLowerCase());
        }
        params.put("message", this.message);
        if (this.notify != null) {
            params.put("notify", this.notify);
        }
        if (this.messageFormat != null) {
            params.put("message_format", this.messageFormat.getValue());
        }
        return params;
    }
}

